<?php 
/*
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	OpenExchangeRates.php Version 0.2
	Copyright 2011, Anastis Sourgoutsidis, http://www.anastis.gr
*/

	class OpenExchangeRates{
		private $rates_url = "http://openexchangerates.org/api/latest.json?app_id=c252c41895bc4d28866f5713385028ff&symbols=EUR,CHF";
		private $base; // The base currency.
		private $rates = array(); // They array of currency rates, relative to the base.
		public $margin = 0.03; // Margin to use for TMS
		
		public function __construct()
		{
			$contents = @file_get_contents($this->rates_url);
			$json = json_decode($contents, true);
			$this->rates = $json['rates'];
			$this->base = $json['base'];
		}
		
		public function getRates(){ return $this->rates; }
		public function getBase(){ return $this->base; }
		
		public function setMargin($newMargin) {
			$this->margin = $newMargin;
		}
		
		public function getRate($currency="USD")
		{
			if( isset( $this->rates[$currency] ) )
			{
				$myRate = substr($this->rates[$currency], 0, 4);
				$myRate -= $this->margin;
				return $myRate;
			}
			return FALSE;
		}
		
		public function change($amount, $from, $to)
		{
			$base = $this->rates[$this->base]; // This should always be 1
			$from = $this->getRate($from);
			$to = $this->getRate($to);
			if ( ($from !== FALSE) and ($to !== FALSE) )
			{
				return $base / $from * $amount * $to;
			}
			return FALSE;
		}
	}
