<?php

/** A PHP class to access VENDORS table with convenient methods
  * in an object oriented way, and with a powerful debug system.\n
  * @version  1.0 
  * @author   Juan Carlos Alvarez (juancarlos@costaricavirtual.com)
  */
// Include the class DB
if (!defined("TMS_ROOT")) {
	die("TMS root path not defined");
}

include_once TMS_ROOT.'class/db/access.php';

class Prices {
    /**
     * holds all variables(properties) of an object
     *
     * @var array
     * @access protected
     */
    var $vars = array();
	var $table = 'prices';
	var $id = 0; //Price_Id
	var $vendor = 0; //Vendor_Id

	/**
     * initialize PRICES object
     * 
     * @access public
     * @param int $id index value
     */
    function Prices($id = null) {
		global $db;
		$this->initVar("Service_Type", -1);
		$this->initVar("Country", -1);
		$this->initVar("From_Date", -1);
		$this->initVar("To_Date", -1);
		$this->initVar("Product_Size", -1);
		$this->initVar("Product_Type", -1);
		$this->initVar("Beds", -1);
		$this->initVar("Occupant_Capacity", -1);
		$this->initVar("Price_Category", -1);
		$this->initVar("Price_Rack", -1);
		$this->initVar("Daily_Rate", -1);
		$this->initVar("Per_Person", -1);
		$this->initVar("Tax_Rate", -1);
		$this->initVar("Price_Comments", -1);
		$this->initVar("Price_Expiration_Date", -1);
		$this->initVar("Price_Last_Updated", -1);
		$this->initVar("Last_updated_by", -1);
		$this->initVar("Quick_Search_Text", -1);
		$this->initVar("QTY", -1);
		$this->initVar("Price_Net", -1);
		$this->initVar("Factor", -1);
		$this->initVar("Currency", -1);
		$this->initVar("Comments", -1);
		$this->initVar("2Publish", -1);
		// if spaces inside variable name are converted to underscores, must be added substitutes inside while loop on getobjects funtion
		
		if (isset($id)) {
			if (intval($id) > 0) {
				$this->id = $id;
				$sql = 'SELECT * FROM `'.$this->table.'` WHERE `Price_Id`='.$id;
				$this->assignVars($db->queryUniqueArray($sql));
			}
		}
	}
	
	/**
     * initialize variables for the object
     *
     * @access public
     * @param string $key
     * @param mixed $value
     */
    function initVar($key, $value = null)
    {
        $this->vars[$key] = array('value' => $value);
    }
	
	/**
     * assign a value to a variable
     *
     * @access public
     * @param string $key name of the variable to assign
     * @param mixed $value value to assign
     */
    function assignVar($key, $value)
    {
        if (isset($key) && isset($this->vars[$key])) {
			if($key == 'detail') {
				$details = self::array_unserialize($value);
				$this->vars[$key]['value'] =& $details;
			} else {
				$this->vars[$key]['value'] =& $value;
			}
		}
    }

    /**
     * assign values to multiple variables in a batch
     *
     * @access private
     * @param array $var_array associative array of values to assign
     */
    function assignVars($var_arr)
    {
        foreach ($var_arr as $key => $value) {
            $this->assignVar($key, $value);
        }
    }
	
	/**
     * returns a specific variable for the object
     *
     * @access public
     * @param string $key key of the object's variable to be returned
     */
    function getVar($key)
    {
        $ret = null;
        if (!isset($this->vars[$key])) {
            return $ret;
        }
		$ret =  $this->vars[$key]['value'];
        return $ret;
	}
	
	/**
	* retrieve items from the database
	* 
	* @param string $criteria conditions to be met
	* @param string $groupBy order to be met
	* @param string $sortOrder order to be met
	* @return array array of objects 
	*/
	function &getObjects($criteria = '', $groupBy = '', $sortOrder = '')
	{
		global $db;
		$ret = false;
		$sql = 'SELECT * FROM `'.$this->table.'`';

		if ($criteria != '') {
			$sql .= " WHERE " . $criteria;
		}

		if ($groupBy != '') {
			$sql .= " GROUP BY " . $groupBy;
		}

		if ($sortOrder != '') {
			$sql .= ' ORDER BY '.$sortOrder;
		}
		
		$result = $db->query($sql);
		if (!$result) {
			return $ret;
		}
		
		$numrows = $db->numRows($result);
		if ($numrows == 0) {
			return $ret;
		}

		$theObjects = array();

		while ($myrow = $db->fetchNextArray($result)) {
			// hack for `Customer Id` field 
			////$myrow['Customer_Id'] = $myrow['Customer Id'];
			////unset($myrow['Customer Id']);
			// end hack
			$item = new Customers();
			$item->assignVars($myrow);

			$theObjects[$myrow['id']] =& $item;
			unset($item);
		}
		$ret = $theObjects;
		
		return $ret;
	}

	/**
	* insert items into the database table
	* 
	* @param array $values values to be added
	* @return nothing 
	*/
	function &putObjects($values = '')
	{
		global $db;
		$ret = false;
		$sql = 'INSERT IGNORE INTO `'.$this->table.'`'; 

		if ($values == '') {
			return $ret;
		}
		// convert custom variables to original name
		$values = self::fixValues($values);
		$values['1-800'] = $values['TEL1-800']; unset($values['TEL1-800']);
		unset($values['Customer Id']); // remove Customer Id

		// get keys and generates sql string
		$keys = array_keys($values);
		$sql .= " (`" . implode("`, `", $keys) . "`) VALUES ('" . implode("', '", $values) . "')";
		$sql = str_replace('\'null\'', 'null', $sql);;
			// write sql to debug log
			tms_debug($sql, "SQL:");
		//$db->execute($sql);
		// $rows = $db->lastAffectedRows();
		// if($rows <= 0 ) {
		// 	// write sql to debug log
		// 	fwrite($file, "\n\nRECORD NOT INSERTED - ".date("Y-m-d h:i")."\n");
		// 	fclose($file);
		// 	return $ret;
		// }
		$ret = $db->lastInsertedId();
			tms_debug($ret, "LAST INSERTED ID:");
		return $ret;
	}
	
	/**
	* convert array keys name from double underscores into space 
	* also verify array variable is an array and clean attrs
	*
	* @param array $values array with all params
	* @return array 
	*/
	function fixValues($values) {
		foreach($values as $key => $value) {
			// search variable name with __ inside and change to space
			if(strpos($key, '__') !== false) {
				$newKey = str_replace('__', ' ', $key);
				$values[$newKey] = $value;
				unset($values[$key]);
				$key = $newKey;
			}
				
			// if array variable is an array
			if(is_array($values[$key])) {
				// if array variable attribute is null
				if($values[$key]['@attributes']['type'] == 'NULL') {
					$values[$key] = 'null';
				}
				// else if array count is 1, assign an empty string
				else if(count($values[$key]) == 1) {
					$values[$key] = '';
				} else {
					unset($values[$key]['@attributes']);
				}
			}
		}
		return $values;
	}

	/**
	* convert an array into a special serialized array
	*
	* @param array $item array with all form field ($_POST)
	* @return array 
	*/
	function array_serialize($item) {
		$ret = serialize($item);
		$ret = urlencode($ret);
		return $ret;
	}

	/**
	* convert a special serialized array into an un-serialized one
	*
	* @param array $item detail info from formulaires
	* @return array 
	*/
	function array_unserialize($item) {
		$ret = stripslashes($item);
		$ret = urldecode($ret);
		$ret = unserialize($ret);
		return $ret;
	}

	/**
	* Creates a CSV file with current vendor record
	*
	* @param $vendor	index value
	* @return null 
	*/
	function exportCSV($vendor = null) {
		global $db;
		if (isset($vendor)) {
			if (intval($vendor) > 0) {
				$this->vendor = $vendor;
				include_once TMS_ROOT.'class/vendors/vendors.class.php';
				$tempVendor = new Vendors($this->vendor);
			}
		} else {
			return null;
		}
		//tms_debug($vendor, "Vendor:");
		include_once TMS_ROOT.'class/db/access.php';
		header('Content-Type: text/csv; charset=utf-8');
		header('Content-Disposition: attachment; filename=prices-' . string2seo($tempVendor->vars["Common Name"]['value']) . '.csv');
		$output = fopen("php://output", "w");
		fputcsv($output, array('Service_Type', 'Country', 'From_Date', 'To_Date', 
			'Product_Size', 'Product_Type', 'Beds', 'Occupant_Capacity', 'Price_Category', 
			'Price_Rack', 'Daily_Rate', 'Per_Person', 'Tax_Rate', 'Price_Comments', 
			'Price_Expiration_Date', 'Price_Last_Updated', 'Last_updated_by', 'Quick_Search_Text',
			'QTY', 'Price_Net', 'Factor', 'Currency', 'Comments','2Publish'));
		//tms_debug($tempVendor->vars["Common Name"]['value'], "Vendor Name:");
		$sqlPrices = "SELECT Price_Id FROM prices WHERE Vendor_Id = " . $this->vendor;
		$result = $db->query($sqlPrices);
		while ($price = $db->fetchNextObject($result)) {
			$tempPrice = new Prices($price->Price_Id);
			//tms_debug($price->Price_Id, "Price Id:");
			foreach ($tempPrice->vars as $key => $value) {
				$valuesarray[] = $tempPrice->vars[$key]['value'];
			}
			fputcsv($output, $valuesarray);
			unset($valuesarray);
		}
		fclose($output);
		return null;
	}

	/**
	* Load a CSV file content and add a new vendor record
	*
	* @param none
	* @return null 
	*/
	function importCSV($csvfile, $vendor) {
		global $db;
		$file = $csvfile[csv][tmp_name]; 
		$handle = fopen($file,"r");
		$sql="DELETE FROM ".$this->table." WHERE `Vendor_Id` = ".$vendor."";
		//tms_debug($sql, "delete prices SQL:");
		$db->execute($sql);
		$sql = "INSERT INTO ".$this->table." (";
		$firstLoop = true;
		//loop through the csv file and insert into database 
		/**/
		while (($data = fgetcsv($handle, 0)) !== FALSE) {
			$count = count($data);
			for ($c=0; $c < $count; $c++) {
				if ($firstLoop) {
					$sql .= "`" . $data[$c] . "`, "; 
				} else {
					$sql .= "'" . addslashes($data[$c]) . "',";
				}
			}
			if ($firstLoop) {
				//$sql = substr($sql, 0, -2);
				$sql .= "`Vendor_Id`) VALUES (";
				$firstLoop = false;
			} else {
				$sql .= "'" . $vendor . "'),(";
			}
		}
		$sql = substr($sql, 0, -2);
		//$sql .= "'" . $vendor . "')";

		tms_debug($sql, "import vendor prices SQL:");
		$db->execute($sql);
		//$newRecord = $db->lastInsertedId();
		return $vendor;
	}
		
}
