<?php
include_once('./include/functions.php');

/*
 * Send Reminders
 */
function reminder() {
	global $db;
	$sql = "SELECT r.id, r.description, DATE_FORMAT(r.date_start,'%b %D, %Y') date_start, r.time_start, r.email_me, DATE_FORMAT(r.date_end,'%b %D, %Y') date_end, r.time_end, c.Name customer_name, c.Email customer_email, c.`Customer Number` customer_number, c.`Customer Id` customer_id, u.email user_email, CONCAT(u.firstname, ' ', u.lastname) user_name FROM reminders r, customers c, users_users u WHERE r.customer_id = c.`Customer Id` AND r.status <> 'sent' AND r.status <> 'completed' AND u.id = r.user_id AND ( r.date_start < CURDATE() OR (r.date_start = CURDATE() AND r.time_start <= CURTIME()) ) ORDER BY r.date_start, r.time_start";
	$db->query($sql);
	$date_cur = date('M dS, Y');
	while ($reminder = $db->fetchNextObject()) {
		// update reminder status as active reminder
		$sql2="UPDATE reminders SET status = 'active' WHERE `id` = ".$reminder->id."";
		if ($reminder->email_me == 1) {
			// update status as sent reminder
			$sql2="UPDATE reminders SET status = 'sent' WHERE `id` = ".$reminder->id."";
			$mailTo = $reminder->user_email;
			$mailSubject = "Reminder from TMS";
			$mailBody = "Reminder description: \t".$reminder->description."\n";
			$mailBody .= "Reminder began: \t".$reminder->date_start.", ";
			$mailBody .= "at ".$reminder->time_start."\n";
			$mailBody .= "Reminder ends: \t\t".$reminder->date_end.", ";
			$mailBody .= "at ".$reminder->time_end."\n";
			$mailBody .= "Reminder assigned to ".$reminder->customer_name;
			$mailBody .= " [".$reminder->customer_number."]\n";
			$mailBody .= TMS."customers.php?customer=".$reminder->customer_id."\n";
			$mailBody .= "Customer Email: \t".$reminder->customer_email."\n\n\n";
			$mailBody .= "Email generated automatically by TMS.";
			$mailHeaders = "From: " . TMS_EMAIL . "\n";
			//$mailHeaders .= "Cc: webmaster@enjoycentralamerica.com\n";
			$resultado = mail($mailTo, $mailSubject, $mailBody, $mailHeaders);
			tms_debug("Mail sent","Reminder:");
		}
		$db->execute($sql2);
	}
	// update reminder status as completed
	$sql="UPDATE reminders SET status = 'completed' WHERE date_end < CURDATE() AND status <> 'completed'";
	$db->execute($sql);
	$registros = mysql_affected_rows();
	if ($registros > 0){
		$date_cur = date('M dS, Y - h:i:s');
		$mailTo = "pepe@magicswitzerland.com";
		$mailSubject = "Reminders Cron";
		$mailBody = $date_cur."\n";
		$mailBody .= $registros." reminders completed.\n\n\n";
		$mailHeaders = "From: " . TMS_EMAIL . "\n";
		$resultado = mail($mailTo, $mailSubject, $mailBody, $mailHeaders);
		tms_debug("$registros records removed","REMINDER:");
	}
}

/*
 * Save Currency exchange rate 
 */
function currencyRate($code) {
	global $db;
	$sql = "SELECT id, date_added FROM currencies WHERE code = '$code'";
	$currency = $db->queryUniqueObject($sql);
	$datetimeDB = new DateTime($currency->date_added);
	$datetimeNOW = new DateTime('NOW');
	$flag = ($datetimeNOW->diff($datetimeDB)->h >= 8) ? TRUE: FALSE;
	if($flag) {
		include_once TMS_ROOT."class/openexchangerates.php";
		$oer = new OpenExchangeRates();
		$newRate = $oer->getRate($code);
		if($newRate > 0) {
			$sql="UPDATE currencies SET rate = $newRate, date_added = '". 
				$datetimeNOW->format('Y-m-d H:i:s') . 
				"' WHERE id = " . $currency->id;
			$db->execute($sql);
			//tms_debug("SQL update=$sql","Currency:");
			tms_debug("Updated $code rate > $newRate, ".$datetimeNOW->format('Y-m-d H:i:s'),"CURRENCY:");
		} else {
			tms_debug("Rate for $code is not valid ($newRate), ".$datetimeNOW->format('Y-m-d H:i:s'),"CURRENCY:");
		}
	}
}

//tms_debug("Start","CRON:");
reminder();
currencyRate('CHF');
currencyRate('EUR');
//tms_debug("End","CRON:");
