﻿<?php
include_once('./include/functions.php');
header('Content-Type: text/xml; charset=ISO-8859-1');

// Function render_agents
// website = tres iniciales del sitio web
// lead = lead id
// recommended = recommended agent name
// procesa los formularios
function render_agents($website, $lead, $recommended = "") {
	global $db;
	$sql = "SELECT u.id, CONCAT(`firstname`,' ',`lastname`) `name` FROM users_users u, `list box text` WHERE `List Box Name`='Referred by' AND `List Box Text` = '".$website."' AND `status` = 2 AND (`group` = 'Sales' OR `group` = 'Supervisor' OR `group` = 'Administrator') AND `targets` REGEXP `Description`;";
	$query = $db->query($sql);
	$numLines = $db->numRows($query);
	if ($numLines == 0) {
		$sql = "SELECT id, CONCAT(`firstname`,' ',`lastname`) name, `email` FROM users_users WHERE `status` = 2 AND (`group` = 'Sales' OR `group` = 'Supervisor' OR `group` = 'Administrator');";
		$query = $db->query($sql);
	}
	$result = '<form name="agents'.$lead.'">';
	$result .= '<select size="1" id="agentid" name="agentid" style="font-size: 10px; color: #888;">';
	$result .= '<option value="">select</option>';
	while ($agent = $db->fetchNextObject($query)) {
		$result .= '<option value="'.$agent->id.'"';
		if ($recommended == $agent->name) {
			$result .= ' selected="selected"';
		}
		$result .= '>'.$agent->name.'</option>';
	}
	$result .= '</select>';
	$result .= ' <a onclick="doAssign(\''.$lead.'\', document.agents'.$lead.'.agentid.value)">';
	$result .= showIcon("agent.png","Assign lead to agent and Create TMS Customer");
	$result .= '</a>'; 
	$result .= '</form>'; 
	return $result;
}

// Function calc_points
// procesa los formularios
// website = tres iniciales del sitio web
// lead = lead id
function calc_points($formulaire) {
/**
5.0 Package Reservation
4.0 Vacation Planner
2.0 Travel Agents Welcome
1.5 Hotel Reservation (leads dobles, triples del mismo cliente = 0.8 c.u. / quad, quinto, en adelante = 0.6 c.u.
1.0 Tour Reservation
1.0 Transfer Reservation
1.0 Contact Us
0.5 Rental Car Reservation
0.5 Retirement 
**/
	switch ($formulaire) {
		case 'Package':
			$points = '5';
			break;
		case 'Vacation Planner':
			$points = '4';
			break;
		case 'Travel Agents Welcome':
			$points = '2';
			break;
		case 'Hotel Reservation':
			$points = '1.5';
			break;
		case 'Tour Reservation':
		case 'Contact Us':
		case 'Transfer':
			$points = '1';
			break;
		case 'Car Rental':
		case 'Retirement':
			$points = '0.5';
			break;
		default:
			$points = '0';
			break;
	}
	return $points;
}

/* Detect Russian chars
 * 
 */
function isRussian($text) {
	$textArray = array_recibe($text);
	// possible way to filter more spam, this should be done in a separate function
	// explode(" ", $textArray('realname'));
	// it should be only 2 array elements, ignore if there are more than 2 elements or just 1 element
	//   negative: "Frez" or "Juan Carlos Alvarez"
	// if element1 = element2 it is likely to be spam => return true
	//   positive: "Pamelapalse Pamelapalse" or "Jamesessek Jamesessek"
	//   negative: "Abi Cool"
	foreach($textArray as $key => $value) {
		//echo "KEY:$key, VALUE:$value<br><br>";
		if(preg_match('/[А-Яа-яЁё]/u', $value)) {
			return true;
		}
	}
    return false;
}
 
/* Filter
 * Find pending records with spam
 * Update status as spam
 */
$sql="SELECT id, detail FROM leads WHERE status = 0 AND detail LIKE '%http%'";
$result=$db->query($sql);
while ($line = $db->fetchNextObject($result)) {
	// details have http more than once?
	if (substr_count($line->detail, 'http') > 1 || isRussian($line->detail)) {
		// update lead status record as spam
		$sql_status="UPDATE leads SET `status` = 2 WHERE `id` = ".$line->id."";
		$db->execute($sql_status);
	}
}
?>

<div style="float: left; width: 82%;" id="column1">
<table id="grupos" class="resizable sortable editable" width="100%">
<thead><tr>
	<th id="formulaire">Form</th>
	<th id="detail">Detail</th>
	<th id="form_date">Date</th>
	<th id="points">Points</th>
	<th id="status" width="140">Action</th>
</tr></thead>
<tbody>
<?php
//include_once('./class/db/access.php');
//$tmp_website = isset($_GET['Enjoy']) ? "<> 'MCH'" : "= 'MCH'";
// added status=3 (nospam) 2018-06-06
$sql="SELECT id, website, formulaire, points, detail, form_date, form_time 
FROM leads WHERE status = 0 OR status = 3 ORDER BY `form_date` DESC, form_time DESC";
$result=$db->query($sql);
while ($line = $db->fetchNextObject($result)) {
	$detail = $agents_select = '';
	// separa cada campo del formulario en detail
	$detail = array_recibe($line->detail);
	//obtiene el nombre del tour
	$tourName = $detail['tourName'];
	// obtiene datos del cliente si esta activo
	$sql_repeater = "SELECT `Customer Number` number, `Customer Id` id, `Name` `name`, `When_updated` `fecha`, `Visit Status` `status`, `Last updated by` agent
	FROM customers WHERE (`Visit Status`='interested' OR `Visit Status`='prospect' 
	OR `Visit Status`='customer') AND `Email` LIKE '%".$detail['email']."%'";
	$repeater = $db->queryUniqueObject($sql_repeater);
	// echo isset($repeater->number) ? '<br><br>number: '.$repeater->number : '';
	$tmsInfo = '';
	if($repeater->id > 0) {
		$tmsInfo = '<br /><span title="Assigned to '.$repeater->agent.'"><b>TMS:</b> <a href="customers.php?customer='.$repeater->id.'">'.$repeater->number.' '.$repeater->name.'</a> <b>CREATED:</b>'.$repeater->fecha.' ['.$repeater->status.']</span>';
	}
	// prepara el detalle a mostrar
	/*
		echo "<pre>";
		print_r($detail);
		echo "</pre";
	/**/
	$detail = render_form($line->formulaire, $detail);
	// Calculo de los puntos de cada lead
	$points = $line->points;
	if ($points == 0) {
		$points = calc_points($line->formulaire);
	}
	$sql_points="UPDATE leads SET `points` = ".$points." WHERE `id` = ".$line->id."";
	$db->execute($sql_points);
	// averigua si el form se envio automaticamente a la agente
	$autoProcess = false;
	/*
	if($line->website == 'EPA' || $line->website == 'PAV'){
		if($line->formulaire == 'Vacation Planner' || 
			$line->formulaire == 'Retirement' || 
			$line->formulaire == 'Tour Reservation' || 
			$line->formulaire == 'Transfer' || 
			$line->formulaire == 'Package'){
			$autoProcess = true;
			$repeater->agent = 'Ana Cetina';
			$agentId = 13;
			//echo '<em>'.$mensaje.'</em>';
		}
	}
	*/
	$agents_select = render_agents($line->website, $line->id, $repeater->agent);
	$myclase = ($myclase=='rowodd') ? 'roweven' : 'rowodd';
?>
<!--
<tr id="<?php echo $line->id?>" onMouseOver="this.style.backgroundColor='oldlace'; this.style.fontWeight='normal';" onMouseOut="this.style.fontWeight='normal'; this.style.backgroundColor='white';">
-->
<tr id="<?php echo $line->id?>" class="<?php echo $myclase?>">
	<td class="noedit" valign="top">
		<?php echo $line->website?><br /><?php echo $line->formulaire?>
	</td>
	<td class="noedit" valign="top"><?php echo $detail?><?php echo $tmsInfo?></td>
	<td class="noedit" valign="top">
		<?php echo $line->form_date?><br>
		<?php echo substr($line->form_time,0,5)?>
	</td>
	<td valign="top" align="center"><?php echo $points?></td>
	<td class="noedit" valign="top" align="right">
		<div id="actions<?php echo $line->id?>">
		<?php echo $agents_select?>
		<br style="line-height:3px;">
		<?php if ($autoProcess) {?>
			<a accesskey="a" onclick="doAuto('<?php echo $line->id?>','<?php echo $agentId?>')">
		<?php echo showIcon("arrow-right.png","Create customer from automatic lead")?></a> 
		<?php } 
		if ($repeater->id != '') {?>
			<a accesskey="p" onclick="doProcessed('<?php echo $line->id?>','<?php echo $repeater->agent?>','<?php echo $repeater->id?>')">
		<?php echo showIcon("flag.gif","Tag this lead as Processed")?></a> 
		<?php } ?>
		<a accesskey="e" onclick="doEmailOnly('<?php echo $line->id?>', document.agents<?php echo $line->id?>.agentid.value)">
		<?php echo showIcon("email_forward.png","Only send email to Agent")?></a> 
		<a accesskey="d" onclick="askDelete('<?php echo $line->id?>')">
		<?php echo showIcon("borrar.gif","Delete this item?")?></a> 
		<a accesskey="s" onclick="tagSpam('<?php echo $line->id?>')">
		<?php echo showIcon("shield.png","Tag as SPAM")?></a>
		</div>
	</td>
</tr>
<?php 
} // while ?>
</tbody>
</table>
</div>
<div style="float: right; width: 165px" id="column2">
<?php
	// get agent name, status and pending leads
	$sql = "SELECT CONCAT(u.firstname, ' ', u.lastname) name, u.status_tms `status`, count(c.Name) pending
		FROM users_users u LEFT JOIN customers c 
		ON c.`Options Sent` = 0 AND (c.`Visit Status` = 'interested' 
		OR c.`Visit Status` = 'prospect' OR `Visit Status` = 'customer') 
		AND c.`Last updated by` = CONCAT(u.firstname, ' ', u.lastname) 
		WHERE u.`status` = 2 AND u.`group` = 'Sales' 
		GROUP BY u.firstname, u.lastname
		ORDER BY SUBSTRING(u.email,INSTR(u.email,'@')+1,5), u.firstname";
	$result = $db->query($sql);
	while ($agent = $db->fetchNextObject($result)) {
		// get leads in current month
		$sql = "SELECT COUNT(Name) leads FROM customers c
		WHERE `Last updated by` = '".$agent->name."' 
		AND SUBSTRING(`Customer Number`,-8,2) = DATE_FORMAT(CURDATE(), '%y') 
		AND SUBSTRING(`Customer Number`,-6,2) = MONTH(CURDATE()) 
		GROUP BY `Last updated by`";
		$leads = $db->queryUniqueValue($sql);
		// get sales in current month
		$sql_sales = "SELECT SUM(A.monto) amount, COUNT(P.nombreCliente) clients 
		FROM $dbpanel.pagos P, $dbpanel.miembros M, $dbpanel.abonos A 
		WHERE P.id_pago = A.pago AND M.id_miembro = P.agente AND 
		CONCAT(M.nombres,' ',M.apellidos) = '".$agent->name."' AND YEAR(A.fecha) = YEAR(CURDATE()) 
		AND MONTH(A.fecha) = MONTH(CURDATE())";
		$sales = $db->queryUniqueObject($sql_sales);
		$colour = getAgentStatus($agent->pending);
		// print agent info
		echo '<div class="agentblock">';
		echo '<h3>';
		echo showIcon($colour.".png",'');
		echo ' '.$agent->name.'</h3>';
		echo 'Pending <strong style="color:red">'.$agent->pending.'</strong>, ';
		echo 'Assigned <strong>'.$leads.'</strong><br>';
		echo 'Sales <strong>'.$sales->clients.'</strong> ->';
		echo showIcon("money_USD.png",'').' '.$sales->amount;
		echo "</div>";
	}
?>
</div>
<br style="clear: both;">