 <?php
	include_once ('functions.php');	

	/*
	Funcion numeroMes
	Parametro mes = nombre del mes
	Devuelve el numero del mes
	*/
	function numeroMes($mes) {
		$numero = 0;
		switch ($mes) {
			case 'Enero':
			case 'January':
				$numero = 1;
				break;
			case 'Febrero':
			case 'February':
				$numero = 2;
				break;
			case 'Marzo':
			case 'March':
				$numero = 3;
				break;
			case 'Abril':
			case 'April':
				$numero = 4;
				break;
			case 'Mayo':
			case 'May':
				$numero = 5;
				break;
			case 'Junio':
			case 'June':
				$numero = 6;
				break;
			case 'Julio':
			case 'July':
				$numero = 7;
				break;
			case 'Agosto':
			case 'August':
				$numero = 8;
				break;
			case 'Setiembre':
			case 'September':
				$numero = 9;
				break;
			case 'Octubre':
			case 'October':
				$numero = 10;
				break;
			case 'Noviembre':
			case 'November':
				$numero = 11;
				break;
			case 'Diciembre':
			case 'December':
				$numero = 12;
				break;
			default:
				//$numero = date("m", mktime(0, 0, 0, $mes, 1, 2000));
				$numero = date("m", strtotime("1 $mes 2000"));
				break;
		} 
		return $numero;
	} // END FUNCTION numeroMes
	
	/*
	Funcion setFields
	Parametro datos = campos del formulario
	Parametro destinos = destinos de un paquete
	Parametro itinerarios = itinerarios de un planner
	Devuelve los valores para llenar el customer_travel
	*/
	function setFields($datos, $destinos, $itinerarios) {
		$result = array();
		// PAX
		$result['PAX'] = isset($datos['howManyAdults']) ? intval($datos['howManyAdults']) : 0;
		$result['PAX'] += isset($datos['howManyChildren']) ? intval($datos['howManyChildren']) : 0;
		$result['PAX'] = isset($datos['people']) ? $datos['people'] : $result['PAX'];
		
		// Intl Arrival Date
		$result['ARRIVAL'] = (isset($datos['checkinMonth']) && isset($datos['checkinDay']) && isset($datos['checkinYear'])) ? 
			$datos['checkinYear'].'-'.numeroMes($datos['checkinMonth']).'-'.$datos['checkinDay'] : $datos['arrival'];
		$result['ARRIVAL'] = (isset($datos['departureMonth']) && isset($datos['departureDay']) && isset($datos['departureYear'])) ? 
			$datos['departureYear'].'-'.numeroMes($datos['departureMonth']).'-'.$datos['departureDay'] : $result['ARRIVAL'];
		$result['ARRIVAL'] = (isset($datos['arriveMonth']) && isset($datos['arriveDay']) && isset($datos['arriveYear'])) ? 
			$datos['arriveYear'].'-'.numeroMes($datos['arriveMonth']).'-'.$datos['arriveDay'] : $result['ARRIVAL'];
		$result['ARRIVAL'] = (isset($datos['fechaMonth']) && isset($datos['fechaDay']) && isset($datos['fechaYear'])) ? 
			$datos['fechaYear'].'-'.numeroMes($datos['fechaMonth']).'-'.$datos['fechaDay'] : $result['ARRIVAL'];
		$result['ARRIVAL'] = (isset($datos['dayMonth']) && isset($datos['dayDay']) && isset($datos['dayYear'])) ? 
			$datos['dayYear'].'-'.numeroMes($datos['dayMonth']).'-'.$datos['dayDay'] : $result['ARRIVAL'];
		$result['ARRIVAL'] = (isset($datos['pickUpMonth']) && isset($datos['pickUpDay']) && isset($datos['pickUpYear'])) ? 
			$datos['pickUpYear'].'-'.numeroMes($datos['pickUpMonth']).'-'.$datos['pickUpDay'] : $result['ARRIVAL'];
		$result['ARRIVAL'] = (isset($datos['arrivalDateMonth']) && isset($datos['arrivalDateDay']) && isset($datos['arrivalDateYear'])) ? 
			$datos['arrivalDateYear'].'-'.numeroMes($datos['arrivalDateMonth']).'-'.$datos['arrivalDateDay'] : $result['ARRIVAL'];

		// Intl Depart Date 
		$result['DEPART'] = (isset($datos['checkoutMonth']) && isset($datos['checkoutDay']) && isset($datos['checkoutYear'])) ? 
			$datos['checkoutYear'].'-'.numeroMes($datos['checkoutMonth']).'-'.$datos['checkoutDay'] : $datos['depart'];
		$result['DEPART'] = (isset($datos['departureMonth']) && isset($datos['departureDay']) && isset($datos['departureYear'])) ? 
			$datos['departureYear'].'-'.numeroMes($datos['departureMonth']).'-'.$datos['departureDay'] : $result['DEPART'];
		$result['DEPART'] = (isset($datos['returnMonth']) && isset($datos['returnDay']) && isset($datos['returnYear'])) ? 
			$datos['returnYear'].'-'.numeroMes($datos['returnMonth']).'-'.$datos['returnDay'] : $result['DEPART'];
		$result['DEPART'] = (isset($datos['dropOffMonth']) && isset($datos['dropOffDay']) && isset($datos['dropOffYear'])) ? 
			$datos['dropOffYear'].'-'.numeroMes($datos['dropOffMonth']).'-'.$datos['dropOffDay'] : $result['DEPART'];
		$result['DEPART'] = (isset($datos['departureDateMonth']) && isset($datos['departureDateDay']) && isset($datos['departureDateYear'])) ? 
			$datos['departureDateYear'].'-'.numeroMes($datos['departureDateMonth']).'-'.$datos['departureDateDay'] : $result['DEPART'];

		// Intl Arrival Time
		$result['TIMEIN'] = isset($datos['pickUpTime']) ? $datos['pickUpTime'] : '';
		$result['TIMEIN'] = isset($datos['arrivalTime']) ? $datos['arrivalTime'] : $result['TIMEIN'];

		// Intl Depart Time
		$result['TIMEOUT'] = isset($datos['departureTime']) ? $datos['departureTime'] : '';
		$result['TIMEOUT'] = isset($datos['dropOffTime']) ? $datos['dropOffTime'] : $result['TIMEOUT'];
		
		// Travel Comments
		// Contact
		$result['COMMENTS'] = (isset($datos['asunto']) || isset($datos['message'])) ? 
			$datos['asunto'].":\n".$datos['message'] : '';
		$result['COMMENTS'] = (isset($datos['subject'])) ? 
			$datos['subject'].":\n".$datos['additionalComments'] : '';
		// Car
		$result['COMMENTS'] = (isset($datos['pickUpLocation']) || isset($datos['typeOfCar']) || isset($datos['dropOffLocation'])) ? 
			'Type of Car: '. $datos['typeOfCar']."\n".
			'Pick Up Location: '. $datos['pickUpLocation']."\n".
			'Drop Off Location: '. $datos['dropOffLocation']."\n".
			'Comments: '. $datos['additionalComments'] : $result['COMMENTS'];
		// Tour
		$result['COMMENTS'] = isset($datos['tourName']) ? 
			'Tour Name: '. $datos['tourName']."\n" : $result['COMMENTS'];
		$result['COMMENTS'] .= isset($datos['tourType']) ? 
			'Tour Type: '. $datos['tourType']."\n".
			'Comments: '. $datos['additionalComments'] : $result['COMMENTS'];
		// Transfer
		$result['COMMENTS'] = isset($datos['typeOfTransfer']) ? 
			'Transfer: '. $datos['typeOfTransfer'].' - '.$datos['type']."\n".
			'From : '. $datos['from']."\n".
			'To: '. $datos['to']."\n".
			'Comments: '. $datos['additionalComments'] : $result['COMMENTS'];
		// Hotel
		$result['COMMENTS'] = isset($datos['hotel']) ? 
			'Hotel: '. $datos['hotel']."\n".
			'Room Type: '. $datos['roomType']."\n".
			'Rooms: '. $datos['noOfRooms']."\n".
			'Comments: '. $datos['additionalComments'] : $result['COMMENTS'];
		// Package
		if (isset($datos['packageName'])) {
			$result['COMMENTS'] = 'Package: '. $datos['packageName']."\n".
				'Budget: '. $datos['budget'];
			foreach($destinos as $destino) {
				$result['COMMENTS'] .= "\n".$destino['key'].': '.$destino['value'];
			}
			$result['COMMENTS'] .= "\nComments: ". $datos['additionalComments'];
		}
		// Planner
		if (isset($itinerarios[0]['days']) || isset($datos['Days_Others'])) {
			$result['COMMENTS'] = 'Budget: '. $datos['budget']."\n".
				'Number of Rooms: '. $datos['noOfRooms']."\n".
				"Trip Total: ". $datos['tripTotal']."\n".
				"Room Preference: ". $datos['accommodationPreference']."\n".
				"Room Options: ". $datos['roomingOptions']."\n".
				"Smoking Preference: ". $datos['Smoking']."\n";
			$result['COMMENTS'] .= isset($datos['carRental']) ?
				"Transportation: ". $datos['carRental']."\n" : '';
			$result['COMMENTS'] .= isset($datos['localFlight']) ?
				"Transportation: ". $datos['localFlight']."\n" : '';
			$result['COMMENTS'] .= isset($datos['privateVan']) ?
				"Transportation: ". $datos['privateVan']."\n" : '';
			$result['COMMENTS'] .= "Preferred dates: ". $datos['preferredDates']."\n".
				"Alternative dates: ". $datos['alternativeDates']."\n".
				"Arrival Airport: ". $datos['arrivalAirport']."\n".		
				"Airline: ". $datos['airline']."\n".
				"Departure Airport: ". $datos['departureAirport'];
			foreach($itinerarios as $itinerario) {
				$result['COMMENTS'] .= "\n".$itinerario['name'].': '.
					$itinerario['days'].' days. Specific: '.$itinerario['specific'];
			}
			$result['COMMENTS'] .= "\nComments: ". $datos['additionalComments'];
		}
		return $result;
	} // END FUNCTION setFields



	$sql="SELECT CONCAT(firstname, ' ', lastname) nombre, `group` grupo FROM users_users 
		WHERE username = '".$_SERVER['REMOTE_USER']."'";
	$usuario_actual = $db->queryUniqueObject($sql);
	$nombre_usuario = $usuario_actual->nombre;
	$grupo_usuario = $usuario_actual->grupo;
	
    switch ($_GET['accion']) {
    case 'spam': // SPAM
		$sql="UPDATE leads SET `status` = 2, `Last_updated_by` = '".$nombre_usuario."' 
			WHERE `id` = ".$_GET['id']."";
		$db->execute($sql);
		echo '<span style="color:red; font-style:italic;">Tagged as SPAM</span>';
        break;
		
    case 'notspam': // NOT SPAM
		$sql="UPDATE leads SET `status` = 0, `Last_updated_by` = '".$nombre_usuario."' 
			WHERE `id` = ".$_GET['id']."";
		$db->execute($sql);
		echo '<span style="color:green; font-style:italic;">Lead Recovered</span>';
        break;
		
    case 'delete':
		$sql="DELETE from leads WHERE `id` = ".$_GET['id']."";
		$db->execute($sql);
		echo '<span style="color:red; font-weight:bold;">Lead deleted</span>';
        break;
		
    case 'processed': // PROCESSED
		$sql="UPDATE leads SET `status` = 1, `agent` = '".$_GET['agent']."' , `Last_updated_by` = '".$nombre_usuario."', `Customer Id` = ".$_GET['customer']." 
			WHERE `id` = ".$_GET['id']."";
		$db->execute($sql);
		echo '<span style="color:green;">Lead Processed</span>';
        break;

    case 'assign':
		$sql="SELECT CONCAT(firstname, ' ', lastname) `name`, email, commission FROM users_users 
			WHERE id = ".$_GET['agent']."";
		$agent = $db->queryUniqueObject($sql);
		$sql="SELECT website, formulaire, detail FROM leads WHERE id = ".$_GET['id']."";
		$lead = $db->queryUniqueObject($sql);
		$detail = array_recibe($lead->detail);
		$detail['realname'] = ucwords(strtolower($detail['realname']));
		$detail['email'] = strtolower($detail['email']);
		// define chars to convert
		$latin_no_accented_chars	= "aaaaaaaceeeeiiiidnoooooouuuuy";
		$latin_accented_chars		= "àáâãäåæçèéêëìíîïðñòóôõöøùúûüý";
		$detail['country'] = strtr($detail['country'], $latin_accented_chars, $latin_no_accented_chars);
		$detail['country'] =  ucwords(strtolower($detail['country']));
		$detail['country'] =  trim($detail['country']);
		switch ($detail['country']) {
			case 'Usa':
				$detail['country'] = 'United States';
				break;
			case 'Uk':
				$detail['country'] = 'United Kingdom';
				break;
			case 'Espana':
				$detail['country'] = 'Spain';
				break;
			default:
				//$detail['country'] =  ucwords(strtolower($detail['country']));
				break;
		}

		// Busca el email en el TMS por si ya existe la entrada
		$repeater = $db->queryUniqueObject(
		"SELECT `Customer Id` id, `Last updated by` agent
		FROM customers WHERE (`Visit Status`='interested' OR `Visit Status`='prospect' 
		OR `Visit Status`='customer') AND `Email` LIKE '%".$detail['email']."%'"
		);
		if (!is_null($repeater->id)) {
			// el lead ya esta en el TMS
			$customer_id= $repeater->id;
			$agentname = $repeater->agent;
		} else {
			// es un nuevo lead
			//Obtiene el id del cliente que se va a agregar
			$customer_id= $db->getAutoIncrement("customers");
			$agentname = $agent->name;
		}

		// DEFINICION DE CONSTANTES PARA CAMPOS DE FORMULARIOS
		// general
		$realname = "\nName:\t\t";
		$email = "Email:\t\t";
		$yourTelephone = "Phone:\t\t";
		$country = "Country:\t\t";
        $additionalComments = "\nComments:\n";
		// contact us
		$asunto = "\nSubject\t\t";
		$message = "Message\t\t";
		// hotel
        $hotel = "Name of Hotel\t";
        $roomType = "Room Type\t";
		$noOfRooms = "Number of Rooms\t";
        $howManyAdults = "Adults\t\t";
		$howManyChildren = "Children\t\t";
        $ageOfChildren = "Age Of Children:\t\t\t";
		$checkinMonth = "\nCheck In \t";
		$checkinDay = " ";
		$checkinYear = ", ";
        $checkoutMonth = "Check Out\t";
		$checkoutDay = " ";
		$checkoutYear = ", ";
		// packages
        $packageName = "Package Name\t";
        $budget = "Budget\t\t";
        $arenal = "Arenal / La Fortuna\t";
		$manuelAntonio = "Manuel Antonio\t\t";
        $golfoDulce = "Golfo Dulce\t\t";
		$monteverde = "Monteverde\t\t";
        $drakeBay = "Bahia Drake\t\t";
		$corcovado = "Corcovado\t\t";
        $nicoya = "Nicoya\t\t";
		$dominical = "Dominical\t\t";
        $papagayo = "Papagayo\t\t";
		$caribbean = "Caribe\t\t";
        $tamarindo = "Tamarindo\t\t";
		$tortuguero = "Tortuguero\t\t";
        $jaco = "Jaco / Hermosa\t";
		$conchal = "Conchal / Ocotal\t";
		// packages EPA
		$panamaCanal = "Panama Canal\t\t";
		$panamaCity = "Panama City\t\t";
		$cascoViejo = "Casco Viejo\t\t";
		$bocasDelToro = "Bocas del Toro\t";
		$sanBlas = "San Blas\t\t";
		$boquete = "Boquete\t\t";
		$playaBlanca = "Playa Blanca\t\t";
		$contadora = "Contadora\t\t";
		$coibaIsland = "Coiba Island\t\t";
		$bocaBrava = "Boca Brava\t\t";
		$kunaYala = "Kuna Yala\t\t";
		$coronado = "Coronado\t\t";
		$portobelo = "Portobelo\t\t";
		$elValle = "El Valle\t\t";
		$volcan = "Volcan\t\t";
		$colon = "Colon\t\t";
		$santiago = "Santiago\t\t";
		$david = "David\t\t";
		$azuero = "Azuero\t\t";
		$veraguas = "Veraguas\t\t";
		$chiriqui = "Chiriqui\t\t";
		$darien = "Darien\t\t";
		// packages EGT
		$tikal = "Tikal\t\t";
		$atitlan = "Atitlan\t\t";
		$highlands = "Highlands\t\t";
		$antigua = "Antigua\t\t";
		$chichicastenango = "Chichicastenango\t\t";
		$rioDulce = "RioDulce\t\t";

		$arriveMonth = "\nArrive Date\t";
        $arriveDay = " ";
		$arriveYear = ", ";
        $departureMonth = "Departure Date:\t";
        $departureDay = " ";
		$departureYear = ", ";
		// tour
		$tourName = "Tour Name\t";
		$tourType = "Tour Type\t";
		$fechaMonth = $dayMonth = "Day\t\t";
        $fechaDay = $dayDay = " ";
		$fechaYear = $dayYear = ", ";
		// tour MCH
		$destination = "\nAnother destination\t";		
		$howManyAdultsAN = "Adults\t\t";		
		$howManyChildrenAN = "Children\t\t";		
		$ageOfChildrenAN = "Age Of Children\t";		
		$dayinMonth = "\nDate\t";
		$dayinDay = " ";
		$dayinYear = ", ";	
		$typeBike = "\nType of bike\t";		
		$daysRental = "\nDays of rental\t";		
		
		// transfer
		$typeOfTransfer = "Type of Transfer\t";
        $from = "From\t\t";
        $to = "To\t\t";
        $type = "Type\t\t";
        $returnMonth = "Return Date\t";
        $returnDay = " ";
		$returnYear = ", ";
		// car
       	$pickUpMonth = "PICK UP\nDate\t\t";
		$pickUpDay = " ";
		$pickUpYear = ", ";
        $pickUpTime = "Time:\t\t";
		$pickUpLocation = "Location:\t";
		$dropOffMonth = "\nDROP OFF\nDate\t\t";
        $dropOffDay = " ";
		$dropOffYear = ", ";
        $dropOffTime = "Time:\t\t";
		$dropOffLocation = "Location:\t";
        $typeOfCar = "\nType Of Car:\t";
		$people = "People:\t\t";
		$persons = "People:\t\t";
		// planner
		$arrivalDateMonth = $arrival = "\nArrival Date\t";
		$arrivalDateDay = " ";
		$arrivalDateYear = ". ";
		$departureDateMonth = $depart = "Departure Date\t";
		$departureDateDay = " ";
		$departureDateYear = ". ";
		$Days_Nature = "\nNature: Days = ";
		$Specific_Nature = "\tSpecific = ";
		$Days_Volcano = "\nVolcano: Days = ";
		$Specific_Volcano = "\tSpecific = ";
		$Days_Beach = "\nBeach: Days = ";
		$Specific_Beach = "\tSpecific = ";
		$Days_Rainforest = "\nRainforest: Days = ";
		$Specific_Rainforest = "\tSpecific = ";
		$Days_NationalParks = "\nNational Parks: Days = ";
		$Specific_NationalParks = "\tSpecific = ";
		$Days_Activity1 = "\nActivity1: Days = ";
		$Specific_Activity1 = "\tSpecific = ";
		$Days_Activity2 = "\nActivity2: Days = ";
		$Specific_Activity2 = "\tSpecific = ";
		$Days_Others = "\nOthers: Days = ";
		$Specific_Others = "\tSpecific = ";
		$Days_Mayan = (isset($detail['Days_Ruins'])) 
			? "\nMayan Society: Days = " 
			: "\nMayan Ruins: Days = ";
		// planner EBZ
		$Specific_Mayan = "\tSpecific = ";
		$Days_Diving = "\nDiving: Days = ";
		$Specific_Diving = "\tSpecific = ";
		// planner EGT
		$Days_Ruins = "\nRuins: Days = ";
		$Specific_Ruins = "\tSpecific = ";
		$Days_Lakes = "\nLakes: Days = ";
		$Specific_Lakes = "\tSpecific = ";
		// planner EPA
		$Days_Highlands = "\nHighlands: Days = ";
		$Specific_Highlands = "\tSpecific = ";
		$Days_Islands = "\nIslands: Days = ";
		$Specific_Islands = "\tSpecific = ";
		$Days_Culture = "\nCulture: Days = ";
		$Specific_Culture = "\tSpecific = ";
		$Days_Colonial = "\nColonial: Days = ";
		$Specific_Colonial = "\tSpecific = ";
		// planner TCR - new fields
		$tripTotal = "Trip Total\t";
		$accommodationPreference = "Accommodation Preference:\t";
		$roomingOptions = "Rooming Preferences:\t\t";
		$Smoking = "Smoking Preference\t";
		$carRental = $localFlight = $privateVan = "Transportation\t";	
		$preferredDates = "Preferred dates:\t";
		$alternativeDates = "Alternative dates:\t";
		$arrivalTime = "Arrival Time:\t\t";
		$arrivalAirport = "Arrival Airport:\t\t";		
		$airline = "Airline:\t\t\t";
		$departureTime = "Departure Time:\t\t";
		$departureAirport = "Departure Airport:\t";
		// planner MCH
		$organization = "Organization:\t";
		$smokingPreference = " and ";
		$methodOfTransportation = "Preferred method of transportation: ";
		$Total = " and Trip Total $";
        $numberTravelers = "Number of travelers:\t\tAdults ";
		$numberChildren = ", Children ";
		$perNightPerson = "Approximate Budget: \t\t";
		$arrivalMonth = "\nArrive Date:\t\t\t";
        $arrivalDay = " ";
		$arrivalYear = ", ";
		$ifUnknownPreferredDates = "If unknown - Preferred Dates: ";
		$typicalSwiss = "\n";
		$Days_typicalSwiss = " Days = ";
		$Specific_typicalSwiss = "\nSpecific = ";
		$mountainResorts = "\n";
		$Days_mountainResorts = " Days = ";
		$Specific_mountainResorts = "\nSpecific = ";
		$lakeSide = "\n";
		$Days_lakeSide = " Days = ";
		$Specific_lakeSide = "\nSpecific = ";
		$otherCities = "\n";
		$Days_otherCities = " Days = ";
		$Specific_otherCities = "\nSpecific = ";
		$generalInterests = "\n";
		$Days_generalInterests = " Days = ";
		$Specific_generalInterests = "\nSpecific = ";

		// Travel Agents Welcome
		$state = "State\t\t";
		$agency = "Name of Agency\t";
		$agencyWeb = "Agency Web Site\t";
		$iataArcNumber = "IATA/ARC number\t";
		$TRUENumber = "TRUE number\t";
		// Inmuebles
        $property = "\nKind of property?\t";
        $pastime = "\nFavorite pastimes?\t";
        $lifestyle = "Lifestyle?\t\t";
        $climatic = "Climatic conditions?\t";
        $medical = "Medical assistance?\t";
        $tropic = "Lived in the tropics?\t";
		$Days_David = "\nDays in David = ";
		$Specific_David = "\tSpecific = ";
		$Days_Elvalle = "\nDays in El Valle = ";
		$Specific_Elvalle = "\tSpecific = ";
		$Days_Panama = "\nDays in Panama City = ";
		$Specific_Panama = "\tSpecific = ";
		$Days_Canal = "\nDays in Panama Canal = ";
		$Specific_Canal = "\tSpecific = ";
		$Days_Bocas = "\nDays in Bocas del Toro = ";
		$Specific_Bocas = "\tSpecific = ";
		$Days_Contadora = "\nDays in Contadora = ";
		$Specific_Contadora = "\tSpecific = ";
		$Days_Boquete = "\nDays in Boquete = ";
		$Specific_Boquete = "\tSpecific = ";
		$Days_Sanblas = "\nDays in San Blas = ";
		$Specific_Sanblas = "\tSpecific = ";
		$Days_Azueros = "\nDays in Azueros = ";
		$Specific_Azueros = "\tSpecific = ";
		$Days_Volcan = "\nDays in Volcan = ";
		$Specific_Volcan = "\tSpecific = ";
		$Days_Santiago = "\nDays in Santiago = ";
		$Specific_Santiago = "\tSpecific = ";
		
		// temporal constant
        $crpackage = "\nCosta Rica Destinations interest:\n";
		// FIN DE DEFINICION DE CONSTANTES PARA CAMPOS DE FORMULARIOS


		// PROCESO DE ARMADO DEL CORREO
		// Encabezados
		$mailfrom = $detail['realname']." <".$detail['email'].">"; //'tms@enjoycentralamerica.com';
		$mailto =  $agent->name." <". $agent->email.">";
		$bcc = ''; //temp control only
		$subject = $lead->website . ' - ' . $lead->formulaire;
		// Cuerpo del mensaje
		$body = '';
		$destinations = $itinerary = array();
		$i = 0;
		foreach( $detail as $key => $value) {
			switch($key) {
			case 'idioma': 				case 'enviar':
			case 'confemail':			case 'flag':
			case 'reset':				case 'submit':
			case 'Enviar':
				break;

			case 'subject':	
				if ($lead->website <> 'CRV'){
					$body .= $asunto.$value."\n";
					$subject .= " - $value";
				}
				break;
				
			case 'arrival':				case 'depart':
			case 'checkinMonth':		case 'checkinDay':
			case 'checkoutMonth':		case 'checkoutDay':
			case 'arriveMonth':			case 'arriveDay':
			case 'arrivalMonth':		case 'arrivalDay':
			case 'departureMonth':		case 'departureDay':
			case 'fechaMonth':			case 'fechaDay':
			case 'dayMonth':			case 'dayDay':
			case 'returnMonth':			case 'returnDay':
			case 'pickUpMonth':			case 'pickUpDay':
			case 'dropOffMonth':		case 'dropOffDay':
			case 'arrivalDateMonth':	case 'arrivalDateDay':
			case 'departureDateMonth':	case 'departureDateDay':
			case 'dayinMonth':			case 'dayinDay':
			case 'numberTravelers':		case 'roomingOptions':
			case 'perNightPerson':		case 'dayinDay':
				if($value > 0 || $value !== '') {
					$body .= $$key.$value;
				}
				break;

			case 'Nature':			case 'Volcano':
			case 'Beach':			case 'Rainforest':
			case 'NationalParks':	case 'Activity1':
			case 'Activity2':		case 'Others':
				$itinerary[$i]['name'] = $value;
				$body .= $$key.$value;
				break;

			case 'typicalSwiss':	case 'mountainResorts':
			case 'lakeSide':		case 'otherCities':
			case 'generalInterests':
				$body .= $$key.$value;
				$temp_key = 'Days_'.$key;
				$body .= $$temp_key.$detail['Days_'.$key];
				$temp_key = 'Specific_'.$key;
				$body .= $$temp_key.$detail['Specific_'.$key]."\n";
				break;

			case 'Days_typicalSwiss':	case 'Specific_typicalSwiss':
			case 'Days_mountainResorts':	case 'Specific_mountainResorts':
			case 'Days_lakeSide':	case 'Specific_lakeSide':
			case 'Days_otherCities':	case 'Specific_otherCities':
			case 'Days_generalInterests':	case 'Specific_generalInterests':
				break;
		
			case 'arenal':		case 'manuelAntonio':
			case 'golfoDulce':	case 'monteverde':
			case 'drakeBay':	case 'corcovado':
			case 'nicoya':		case 'dominical':
			case 'papagayo':	case 'caribbean':
			case 'tamarindo':	case 'tortuguero':
			case 'jaco':		case 'conchal':
				$destinations[$i]['key'] = $$key;
				$destinations[$i]['value'] = $value;
				$i++;
				$body .= $crpackage;
				$body .= $$key.$value."\n";
				$crpackage = '';
				break;

			default:
				$body .= $$key.$value."\n";
				if (strstr($key, 'Days_')) {
					$itinerary[$i]['days'] = $value;
				}
				if (strstr($key, 'Specific_')) {
					$itinerary[$i]['specific'] = $value;
					$i++;
				}
				break;
			}
		} // fin del foreach
		// FIN DEL PROCESO DE ARMADO DEL CORREO 

		// PROCESO FINAL PARA ENVIAR EL CORREO
		// Footer del cuerpo del mensaje
		$body .= "\n";
        $body .= "Note: Information for internal use only. Please, REMOVE this text before you reply to customer.\n";
        $body .= "Email generated automatically by TMS.\n";
        $body .= "\nDirect Link to Customer Itinerary:\n";
        $body .= TMS. "customers.php?customer=".$customer_id."\n";
		$body = br2nl($body);
		$bodyHTML = nl2br2($body);
		$bodyHTML = str_replace('\t', '', $bodyHTML);
		$errorMessage = '';
		$mailResult = send_email($mailfrom, $mailto, $bcc, $subject, $body, true);
		// check if error sending the email
		if(!$mailResult) {
			$errorMessage = ' - Email failed: '.error_get_last()['message'];
		}
		// FIN DEL PROCESO FINAL PARA ENVIAR EL CORREO
		
		// CREATE ENTRY INSIDE CUSTOMERS
		if (is_null($repeater->id)) { // New Lead
		
			// Set valid Customer Number - first part "AT+2digitsyear+2digitsmonth" = AT1610
			//$max = $db->maxOfAll("Customer Number", "customers");
			$max = $db->queryUniqueValue("SELECT `Customer Number` FROM `customers` ORDER BY `Customer Id` DESC");
			$customer = $number = '';
			$customer = 'AT'.date('y').date('m');
			$number = substr($max,6,4)+1;
			$len_number = strlen($number);
			if ($len_number < 4) {
				for ($i=$len_number; $i<4; $i++) {
					$number = '0'.$number;
				}
			}

			// Get Website language
			$sql = "SELECT `List Box Order` FROM `list box text` WHERE `List Box Name` = 'Sites' AND `List Box Text`='".$lead->website."'";
			$language = $db->queryUniqueValue($sql);
			
			// Set processing fee
			$procfeepc = (substr($lead->website,0,1) == 'M') ? 0 : 4;
			$procfeepc = ($lead->website == 'CHV') ? 0 : $procfeepc;
			$procfeepc = ($lead->website == 'EPA') ? 2 : $procfeepc;
			$procfeepc = ($lead->website == 'PAV') ? 2 : $procfeepc;

			// Insert data into 'customers'
			$lead->formulaire = ''; // RESET DE LOS COMMENTS EN STATUS TAB SOLICITADO POR PEPE 28-10-2011
			$sql = "INSERT INTO `customers` (`Customer Number`, `Name`, `Email`, `Phone`, `Referred by`, `Last updated by`, `When_updated`, `Language`, `Country`, `Customer Comments`, `Visit Status`, `commissionpc`, `CreatedBy`, `procfeepc`) 
			VALUES ('".$customer.$number."','".$detail['realname']."', '".$detail['email']."', '".$detail['yourTelephone']."', '".$lead->website."', '".$agent->name."', '".date('Y-m-d H:i:s')."', '".$language."', '".$detail['country']."', '".$lead->formulaire."', 'interested', ".$agent->commission.", '".$nombre_usuario."', ".$procfeepc.")";
			//$tempmsj = "<br>".$sql;
			$db->execute($sql);
			$result = setFields($detail, $destinations, $itinerary);
			
			// Insert data into 'customers_travel'
			$result['COMMENTS'] = ''; // RESET DE LOS COMMENTS EN TRAVEL INFO SOLICITADO POR PEPE 28-10-2011
			$sql = "INSERT INTO `customers_travel` (`Customer Id`, `Intl Arrival Date`, `Intl Arrival Time`, `Intl Depart Date`, `Intl Depart Time`, `Travel Comments`, `PAX`, `Last updated by`) 
			VALUES (".$customer_id.",'".$result['ARRIVAL']."', '".$result['TIMEIN']."', '".$result['DEPART']."', '".$result['TIMEOUT']."', '".$result['COMMENTS']."', '".$result['PAX']."', '".$agent->name."')";
			//$tempmsj .= "<br>".$sql;
			$db->execute($sql);
		}
		// END - CREATE ENTRY INSIDE CUSTOMERS

		// UPDATE LEAD STATUS = PROCESSED
		$sql="UPDATE leads SET `status` = 1, `agent` = '".$agentname."' , `Last_updated_by` = '".$nombre_usuario."', `Customer Id` = ".$customer_id." 
			WHERE `id` = ".$_GET['id']."";
		$db->execute($sql);
		// END - UPDATE LEAD STATUS

		echo '<span style="color:navy;">Assigned to '.$agentname.$errorMessage.'</span>';
		break;


    case 'auto':
		/*
		autoProcess
		Parametro id = id del lead
		Parametro agent = id del agente
		Devuelve el texto a mostrar
		*/
		$sql="SELECT CONCAT(firstname, ' ', lastname) `name`, email, commission 
			FROM users_users WHERE id = ".$_GET['agent']."";
		$agent = $db->queryUniqueObject($sql);
		$sql="SELECT website, formulaire, detail FROM leads WHERE id = ".$_GET['id']."";
		$lead = $db->queryUniqueObject($sql);
		$detail = array_recibe($lead->detail);
		$detail['realname'] = ucwords(strtolower($detail['realname']));
		$detail['email'] = strtolower($detail['email']);
	
		// Busca el email en el TMS por si ya existe la entrada
		$repeater = $db->queryUniqueObject(
		"SELECT `Customer Id` id, `Last updated by` agent
		FROM customers WHERE (`Visit Status`='interested' OR `Visit Status`='prospect' 
		OR `Visit Status`='customer') AND `Email` LIKE '%".$detail['email']."%'"
		);
		if (!is_null($repeater->id)) {
			// el lead ya esta en el TMS
			$customer_id= $repeater->id;
			$agentname = $repeater->agent;
		} else {
			// es un nuevo lead
			//Obtiene el id del cliente que se va a agregar
			$customer_id= $db->getAutoIncrement("customers");
			$agentname = $agent->name;
		}
	
		// PROCESO PARA MOVER EL LEAD A PROCESSED
		// Update lead record
		$sql="UPDATE leads SET `status` = 1, `agent` = '".$agentname."' , `Last_updated_by` = '".$nombre_usuario."', `Customer Id` = ".$customer_id." 
			WHERE `id` = ".$_GET['id']."";
		/***/
		$db->execute($sql);
		/***/
		$mensaje = '<br>'.$sql;
		// FIN DEL PROCESO PARA MOVER EL LEAD A PROCESSED
		
		if (is_null($repeater->id)) {
			// es un nuevo lead
			// PROCESO PARA CREAR LA ENTRADA EN RESERVATIONS
			// Obtiene el default para el Customer Number
			//$max = $db->maxOfAll("Customer Number", "customers");
			$max = $db->queryUniqueValue("SELECT `Customer Number` FROM `customers` ORDER BY `Customer Id` DESC");
			$customer = $number = '';
			$customer = 'ET'.date('y').date('m');
			$number = substr($max,6,4)+1;
			$len_number = strlen($number);
			if ($len_number < 4) {
				for ($i=$len_number; $i<4; $i++) {
					$number = '0'.$number;
				}
			}
			
			// Obtiene el idioma del sitio
			$sql = "SELECT `List Box Order` FROM `list box text` WHERE `List Box Name` = 'Sites' AND `List Box Text`='".$lead->website."'";
			$language = $db->queryUniqueValue($sql);
			
			// Agrega datos generalers del cliente
			$lead->formulaire = ''; // RESET DE LOS COMMENTS EN STATUS TAB SOLICITADO POR PEPE 28-10-2011
			$sql = "INSERT INTO `customers` (`Customer Number`, `Name`, `Email`, `Phone`, `Referred by`, `Last updated by`, `When_updated`, `Language`, `Country`, `Customer Comments`, `Visit Status`, `commissionpc`, `CreatedBy`) 
			VALUES ('".$customer.$number."','".$detail['realname']."', '".$detail['email']."', '".$detail['yourTelephone']."', '".$lead->website."', '".$agent->name."', '".date('Y-m-d H:i:s')."', '".$language."', '".$detail['country']."', '".$lead->formulaire."', 'interested', ".$agent->commission.", '".$nombre_usuario."')";
			//$tempmsj = "<br>".$sql;
			/***/
			$db->execute($sql);
			/***/
			$mensaje .= '<br>'.$sql;
			// echo '<br>detail:<br><pre>'.print_r($detail);
			// echo '</pre><br>destinations: '.$destinations;
			// echo '<br>itinerary: '.$itinerary;
			$result = array();
			$result = setFields($detail, $destinations, $itinerary);
			// echo '<br><br><pre>'.print_r($result).'</pre>';
			
			// Agrega datos de viaje del cliente
			$result['COMMENTS'] = ''; // RESET DE LOS COMMENTS EN TRAVEL INFO SOLICITADO POR PEPE 28-10-2011
			$sql = "INSERT INTO `customers_travel` (`Customer Id`, `Intl Arrival Date`, `Intl Arrival Time`, `Intl Depart Date`, `Intl Depart Time`, `Travel Comments`, `PAX`, `Last updated by`) 
			VALUES (".$customer_id.",'".$result['ARRIVAL']."', '".$result['TIMEIN']."', '".$result['DEPART']."', '".$result['TIMEOUT']."', '".$result['COMMENTS']."', '".$result['PAX']."', '".$agent->name."')";
			//$tempmsj .= "<br>".$sql;
			/***/
			$db->execute($sql);
			// FIN DEL PROCESO PARA CREAR LA ENTRADA EN RESERVATIONS
			/***/
			$mensaje .= '<br>'.$sql;
		} // end if is null repeater id

		// Se envia un email de notificacion
		// PROCESO DE ARMADO DEL CORREO
		// Encabezados
		$mailfrom = "TMS <travel@absolutetravel-llc.com>";
		$mailto = $agent->email; //'webmaster@enjoycentralamerica.com';
		//$bcc = 'copy@magicswitzerland.com'; //temp control only
		$subject = $lead->website.': Customer created from '.$lead->formulaire.' form';
		// Cuerpo del mensaje
		$body = 'The '.$lead->formulaire.' form filled by ';
		$body .= $detail['realname'].' (';
		$body .= $detail['email'].') ';
		$body .= 'has been added to TMS';
        $body .= "\n\nTMS Direct Link to Customer Itinerary:\n";
        $body .= TMS. "customers.php?customer=".$customer_id."\n";
		send_email($mailfrom, $mailto, $bcc, $subject, $body);
		// FIN DEL PROCESO FINAL PARA ENVIAR EL CORREO
		
		$mensaje = 'Customer created.';
		echo $mensaje;
		break;


    case 'emailonly':
		$sql="SELECT CONCAT(firstname, ' ', lastname) `name`, email, commission FROM users_users 
			WHERE id = ".$_GET['agent']."";
		$agent = $db->queryUniqueObject($sql);
		$sql="SELECT website, formulaire, detail FROM leads WHERE id = ".$_GET['id']."";
		$lead = $db->queryUniqueObject($sql);
		$detail = array_recibe($lead->detail);
		$detail['realname'] = ucwords(strtolower($detail['realname']));
		$detail['email'] = strtolower($detail['email']);
		$customer_id= $db->getAutoIncrement("customers");
		$agentname = $agent->name;

		// DEFINICION DE CONSTANTES PARA CAMPOS DE FORMULARIOS
		// general
		$realname = "\nName:\t\t";
		$email = "Email:\t\t";
		$yourTelephone = "Phone:\t\t";
		$country = "Country:\t\t";
        $additionalComments = "\nComments:\n";
		// contact us
		$asunto = "\nSubject\t\t";
		$message = "Message\t\t";
		// hotel
        $hotel = "Name of Hotel\t";
        $roomType = "Room Type\t";
		$noOfRooms = "Number of Rooms\t";
        $howManyAdults = "Adults\t\t";
		$howManyChildren = "Children\t\t";
        $ageOfChildren = "Age Of Children:\t\t\t";
		$checkinMonth = "\nCheck In\t";
		$checkinDay = " ";
		$checkinYear = ", ";
        $checkoutMonth = "Check Out\t";
		$checkoutDay = " ";
		$checkoutYear = ", ";
		// packages
        $packageName = "Package Name\t";
        $budget = "Budget\t\t";
        $arenal = "Arenal / La Fortuna\t";
		$manuelAntonio = "Manuel Antonio\t\t";
        $golfoDulce = "Golfo Dulce\t\t";
		$monteverde = "Monteverde\t\t";
        $drakeBay = "Bahia Drake\t\t";
		$corcovado = "Corcovado\t\t";
        $nicoya = "Nicoya\t\t";
		$dominical = "Dominical\t\t";
        $papagayo = "Papagayo\t\t";
		$caribbean = "Caribe\t\t";
        $tamarindo = "Tamarindo\t\t";
		$tortuguero = "Tortuguero\t\t";
        $jaco = "Jaco / Hermosa\t";
		$conchal = "Conchal / Ocotal\t";
		// packages EPA
		$panamaCanal = "Panama Canal\t\t";
		$panamaCity = "Panama City\t\t";
		$cascoViejo = "Casco Viejo\t\t";
		$bocasDelToro = "Bocas del Toro\t";
		$sanBlas = "San Blas\t\t";
		$boquete = "Boquete\t\t";
		$playaBlanca = "Playa Blanca\t\t";
		$contadora = "Contadora\t\t";
		$coibaIsland = "Coiba Island\t\t";
		$bocaBrava = "Boca Brava\t\t";
		$kunaYala = "Kuna Yala\t\t";
		$coronado = "Coronado\t\t";
		$portobelo = "Portobelo\t\t";
		$elValle = "El Valle\t\t";
		$volcan = "Volcan\t\t";
		$colon = "Colon\t\t";
		$santiago = "Santiago\t\t";
		$david = "David\t\t";
		$azuero = "Azuero\t\t";
		$veraguas = "Veraguas\t\t";
		$chiriqui = "Chiriqui\t\t";
		$darien = "Darien\t\t";
		// packages EGT
		$tikal = "Tikal\t\t";
		$atitlan = "Atitlan\t\t";
		$highlands = "Highlands\t\t";
		$antigua = "Antigua\t\t";
		$chichicastenango = "Chichicastenango\t\t";
		$rioDulce = "RioDulce\t\t";

		$arriveMonth = "\nArrive Date\t";
        $arriveDay = " ";
		$arriveYear = ", ";
        $departureMonth = "Departure Date\t";
        $departureDay = " ";
		$departureYear = ", ";
		
		// tour
		$tourName = "Tour Name\t";
		$tourType = "Tour Type\t";
		$fechaMonth = $dayMonth = "Day\t\t";
        $fechaDay = $dayDay = " ";
		$fechaYear = $dayYear = ", ";
		// tour MCH
		$destination = "\nAnother destination\t";		
		$howManyAdultsAN = "Adults\t\t";		
		$howManyChildrenAN = "Children\t\t";		
		$ageOfChildrenAN = "Age Of Children\t";		
		$dayinMonth = "Date\t";
		$dayinDay = " ";
		$dayinYear = ", ";
		$typeBike = "\nType of bike\t";		
		$daysRental = "\nDays of rental\t";		
				
		// transfer
        $typeOfTransfer = "Type of Transfer\t";
        $from = "From\t\t";
        $to = "To\t\t";
        $type = "Type\t\t";
        $returnMonth = "Return Date\t";
        $returnDay = " ";
		$returnYear = ", ";

		
		// car
       	$pickUpMonth = "PICK UP:\nDate\t\t";
		$pickUpDay = " ";
		$pickUpYear = ", ";
        $pickUpTime = "Time\t\t";
		$pickUpLocation = "Location\t";
		$dropOffMonth = "\nDROP OFF:\nDate\t\t";
        $dropOffDay = " ";
		$dropOffYear = ", ";
        $dropOffTime = "Time\t\t";
		$dropOffLocation = "Location\t";
        $typeOfCar = "\nType Of Car\t";
		$people = "People\t\t";
		$persons = "People\t\t";
		// planner
		$arrivalDateMonth = "\nArrival Date\t";
		$arrivalDateDay = " ";
		$arrivalDateYear = ". ";
		$departureDateMonth = "Departure Date\t";
		$departureDateDay = " ";
		$departureDateYear = ". ";
		$Days_Nature = "\tNature: Days = ";
		$Specific_Nature = "Specific = ";
		$Days_Volcano = "\t\tVolcano: Days = ";
		$Specific_Volcano = "Specific = ";
		$Days_Beach = "\t\tBeach: Days = ";
		$Specific_Beach = "Specific = ";
		$Days_Rainforest = "\tRainforest: Days = ";
		$Specific_Rainforest = "Specific = ";
		$Days_NationalParks = "\tNational Parks: Days = ";
		$Specific_NationalParks = "Specific = ";
		$Days_Activity1 = "\tActivity1: Days = ";
		$Specific_Activity1 = "Specific = ";
		$Days_Activity2 = "\tActivity2: Days = ";
		$Specific_Activity2 = "Specific = ";
		$Days_Others = "\t\tOthers: Days = ";
		$Specific_Others = "Specific = ";
		$Days_Mayan = (isset($detail['Days_Ruins'])) 
			? "\t\tMayan Society: Days = " 
			: "\t\tMayan Ruins: Days = ";
		// planner EBZ
		$Specific_Mayan = "Specific = ";
		$Days_Diving = "\t\tDiving: Days = ";
		$Specific_Diving = "Specific = ";
		// planner EGT
		$Days_Ruins = "\t\tRuins: Days = ";
		$Specific_Ruins = "Specific = ";
		$Days_Lakes = "\t\tLakes: Days = ";
		$Specific_Lakes = "Specific = ";
		// planner EPA
		$Days_Highlands = "\t\tHighlands: Days = ";
		$Specific_Highlands = "Specific = ";
		$Days_Islands = "\t\tIslands: Days = ";
		$Specific_Islands = "Specific = ";
		$Days_Culture = "\t\tCulture: Days = ";
		$Specific_Culture = "Specific = ";
		$Days_Colonial = "\t\tColonial: Days = ";
		$Specific_Colonial = "Specific = ";
		// planner TCR - new fields
		$tripTotal = "Trip Total\t";
		$accommodationPreference = "Accommodation Preference:\t";
		$roomingOptions = "Rooming Preferences:\t";
		$Smoking = "Smoking Preference\t";
		$carRental = $localFlight = $privateVan = "Transportation\t";	
		$preferredDates = "Preferred dates:\t";
		$alternativeDates = "Alternative dates:\t";
		$arrivalTime = "Arrival Time:\t\t";
		$arrivalAirport = "Arrival Airport:\t\t\t";		
		$airline = "Airline:\t\t\t";
		$departureTime = "Departure Time:\t\t";
		$departureAirport = "Departure Airport:\t";
		// planner MCH
		$organization = "Organization:\t";
		$smokingPreference = " and ";
		$methodOfTransportation = "Preferred method of transportation: ";
		$Total = " and Trip Total $";
        $numberTravelers = "Number of travelers:\t\tAdults ";
		$numberChildren = ", Children ";
		$perNightPerson = "Approximate Budget: \t\t";
		$arrivalMonth = "\nArrive Date:\t\t\t";
        $arrivalDay = " ";
		$arrivalYear = ", ";
		$ifUnknownPreferredDates = "If unknown - Preferred Dates: ";
		$typicalSwiss = "\n";
		$Days_typicalSwiss = " Days = ";
		$Specific_typicalSwiss = "\nSpecific = ";
		$mountainResorts = "\n";
		$Days_mountainResorts = " Days = ";
		$Specific_mountainResorts = "\nSpecific = ";
		$lakeSide = "\n";
		$Days_lakeSide = " Days = ";
		$Specific_lakeSide = "\nSpecific = ";
		$otherCities = "\n";
		$Days_otherCities = " Days = ";
		$Specific_otherCities = "\nSpecific = ";
		$generalInterests = "\n";
		$Days_generalInterests = " Days = ";
		$Specific_generalInterests = "\nSpecific = ";
		
		// Travel Agents Welcome
		$state = "State\t\t";
		$agency = "Name of Agency\t";
		$agencyWeb = "Agency Web Site\t";
		$iataArcNumber = "IATA/ARC number\t";
		$TRUENumber = "TRUE number\t";
		// Inmuebles
        $property = "\nKind of property?\t";
        $pastime = "\nFavorite pastimes?\t";
        $lifestyle = "Lifestyle?\t\t";
        $climatic = "Climatic conditions?\t";
        $medical = "Medical assistance?\t";
        $tropic = "Lived in the tropics?\t";
		$Days_David = "\nDays in David = ";
		$Specific_David = "\tSpecific = ";
		$Days_Elvalle = "\nDays in El Valle = ";
		$Specific_Elvalle = "\tSpecific = ";
		$Days_Panama = "\nDays in Panama City = ";
		$Specific_Panama = "\tSpecific = ";
		$Days_Canal = "\nDays in Panama Canal = ";
		$Specific_Canal = "\tSpecific = ";
		$Days_Bocas = "\nDays in Bocas del Toro = ";
		$Specific_Bocas = "\tSpecific = ";
		$Days_Contadora = "\nDays in Contadora = ";
		$Specific_Contadora = "\tSpecific = ";
		$Days_Boquete = "\nDays in Boquete = ";
		$Specific_Boquete = "\tSpecific = ";
		$Days_Sanblas = "\nDays in San Blas = ";
		$Specific_Sanblas = "\tSpecific = ";
		$Days_Azueros = "\nDays in Azueros = ";
		$Specific_Azueros = "\tSpecific = ";
		$Days_Volcan = "\nDays in Volcan = ";
		$Specific_Volcan = "\tSpecific = ";
		$Days_Santiago = "\nDays in Santiago = ";
		$Specific_Santiago = "\tSpecific = ";
		
		// temporal constant
        $crpackage = "\nCosta Rica Destinations interest:\n";
		// FIN DE DEFINICION DE CONSTANTES PARA CAMPOS DE FORMULARIOS


		// PROCESO DE ARMADO DEL CORREO
		// Encabezados
		$mailfrom = $detail['realname']." <".$detail['email'].">"; //'tms@enjoycentralamerica.com';
		$mailto = $agent->email;
		//$bcc = 'copy@magicswitzerland.com'; //temp control only
		$subject = $lead->website . ' - ' . $lead->formulaire;
		// Cuerpo del mensaje
		$body = '';
		$destinations = $itinerary = array();
		$i = 0;
		foreach( $detail as $key => $value) {
			switch($key) {
			case 'idioma': 				case 'enviar':
			case 'confemail':			case 'flag':
			case 'reset':				case 'submit':
			case 'Enviar':
				break;

			case 'subject':	
				if ($lead->website <> 'CRV'){
					$body .= $asunto.$value."\n";
				}
				break;
				
			case 'checkinMonth':		case 'checkinDay':
			case 'checkoutMonth':		case 'checkoutDay':
			case 'arriveMonth':			case 'arriveDay':
			case 'arrivalMonth':		case 'arrivalDay':
			case 'departureMonth':		case 'departureDay':
			case 'fechaMonth':			case 'fechaDay':
			case 'dayMonth':			case 'dayDay':
			case 'returnMonth':			case 'returnDay':
			case 'pickUpMonth':			case 'pickUpDay':
			case 'dropOffMonth':		case 'dropOffDay':
			case 'arrivalDateMonth':	case 'arrivalDateDay':
			case 'departureDateMonth':	case 'departureDateDay':
			case 'dayinMonth':			case 'dayinDay':
			case 'numberTravelers':		case 'roomingOptions':
			case 'perNightPerson':		case 'dayinDay':
				$body .= $$key.$value;
				break;

			case 'Nature':			case 'Volcano':
			case 'Beach':			case 'Rainforest':
			case 'NationalParks':	case 'Activity1':
			case 'Activity2':		case 'Others':
				$itinerary[$i]['name'] = $value;
				$body .= $$key.$value;
				break;

			case 'typicalSwiss':	case 'mountainResorts':
			case 'lakeSide':		case 'otherCities':
			case 'generalInterests':
				$body .= $$key.$value;
				$temp_key = 'Days_'.$key;
				$body .= $$temp_key.$detail['Days_'.$key];
				$temp_key = 'Specific_'.$key;
				$body .= $$temp_key.$detail['Specific_'.$key]."\n";
				break;

			case 'Days_typicalSwiss':	case 'Specific_typicalSwiss':
			case 'Days_mountainResorts':	case 'Specific_mountainResorts':
			case 'Days_lakeSide':	case 'Specific_lakeSide':
			case 'Days_otherCities':	case 'Specific_otherCities':
			case 'Days_generalInterests':	case 'Specific_generalInterests':
				break;
		
			case 'arenal':		case 'manuelAntonio':
			case 'golfoDulce':	case 'monteverde':
			case 'drakeBay':	case 'corcovado':
			case 'nicoya':		case 'dominical':
			case 'papagayo':	case 'caribbean':
			case 'tamarindo':	case 'tortuguero':
			case 'jaco':		case 'conchal':
				$destinations[$i]['key'] = $$key;
				$destinations[$i]['value'] = $value;
				$i++;
				$body .= $crpackage;
				$body .= $$key.$value."\n";
				$crpackage = '';
				break;

			default:
				$body .= $$key.$value."\n";
				if (strstr($key, 'Days_')) {
					$itinerary[$i]['days'] = $value;
				}
				if (strstr($key, 'Specific_')) {
					$itinerary[$i]['specific'] = $value;
					$i++;
				}
				break;
			}
		} // fin del foreach
		// FIN DEL PROCESO DE ARMADO DEL CORREO 

		// PROCESO FINAL PARA ENVIAR EL CORREO
		// Footer del cuerpo del mensaje
		$body .= "\n";
		send_email($mailfrom, $mailto, $bcc, $subject, $body);

		// UPDATE LEAD STATUS
		$sql="UPDATE leads SET `status` = 1, `agent` = '".$_GET['agent']."' , `Last_updated_by` = '".$nombre_usuario."' WHERE `id` = ".$_GET['id']."";
		$db->execute($sql);

		echo '<span style="color:navy;">Email Sent to '.$agentname.'</span>';
		break;


    default:
        break;
    }
?>