<?php
// Save original memory limit
$original_mem = ini_get('memory_limit');
// Set it to a higher value
ini_set('memory_limit','640M');
// Set maximun execution time to a higher value 
ini_set('max_execution_time', 300);
ini_set('display_errors', 1);

if ( isset($_GET["customer"])) {
	include('../include/functions.php');
	
	// Read customer data
	$sql="SELECT `Customer Number` Number, Name, `Last updated by` agent, `Referred by` referred FROM customers 
		WHERE `Customer Id` = ".$_GET["customer"];
	$customer= $db->queryUniqueObject($sql);

	// Load customer itinerary HTML
	$content = file_get_contents($_GET["customer"].'.html');
	$content = str_replace(chr(10), " ", $content); //remove carriage returns
	$content = str_replace(chr(13), " ", $content); //remove carriage returns

	// Final content will be stored in an array
	$pages = array(); 
	/* DISABLED
	$rowbreak = "[rowbreak]"; // rowbreak used to paginate inside table rows
	$replace = "</p></td></tr></tbody></table>[pagebreak]<table><tbody><tr><td style='width: 80px;' align='center' valign='top'>&nbsp;</td><td style='width: 500px;'><p>";
	$content = str_replace($rowbreak, $replace, $content);
	*/
	$pagebreak = "[pagebreak]";
	$replace = "</blockquote></div>[pages]<div id=\"dates\"><blockquote><p>";
	$content = str_replace($pagebreak, $replace, $content);
	
	$pages = explode("[pages]", $content);	// pagebreak used to paginate content

	// Load PDF library
	/* */
	require_once('../class/mpdf/vendor/autoload.php');
	$mpdf = new mPDF('', 'Letter', 0, '', 5, 5, 15, 15, 9, 9);
	//  mPDF ([ string $mode [, mixed $format [, float $default_font_size [, string $default_font [, float $margin_left , float $margin_right , float $margin_top , float $margin_bottom , float $margin_header , float $margin_footer [, string $orientation ]]]]]])
	// new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, 'L');
	// set options
	/* */
	$mpdf->showImageErrors = true;
	$mpdf->SetCreator('mPDF');
	$mpdf->SetAuthor($customer->agent);
	$mpdf->SetTitle(COMPANY_NAME." Itinerary");
	$mpdf->SetSubject("Detailed Itinerary by ".COMPANY_NAME);
	$mpdf->SetKeywords("magic, switzerland, europe, itinerary, schedule");
	$mpdf->autoPageBreak = true;
	$mpdf->SetProtection(array('print','print-highres'), '', 'TMS');
	/* */
	$stylesheet = file_get_contents('style.css');
	$mpdf->WriteHTML($stylesheet,1);
	foreach ($pages as $page) {
		//$pdf->SetFont("vera", "", 8);
		$mpdf->AddPage();
		$mpdf->writeHTML($page, 2);
	}
	$mpdf->Output('itinerary.pdf', 'D');
	/* */
}

	/*
	// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {
		
		//Page footer
		function Footer() {
			
		}
	}
	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true); 
	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($customer->agent);
	$pdf->SetTitle(COMPANY_NAME." Itinerary");
	$pdf->SetSubject("Detailed Itinerary by ".COMPANY_NAME);
	$pdf->SetKeywords("magic, switzerland, europe, itinerary, schedule");
	
	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
	
	//set margins
	$pdf->SetMargins(5, 10, 5);
	$pdf->SetHeaderMargin(0);
	$pdf->SetFooterMargin(0);
	
	//set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, 10);
	
	//set image scale factor
	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
	
	//set some language-dependent strings
	$pdf->setLanguageArray($l); 
	
	// add a page
	$pdf->setHeaderData("", "", "", "");
	$pdf->setPrintHeader(false);

	// print content
	$fecha_hora=date('F j, Y - g:i a');
	
	foreach ($pages as $page) {
		//$pdf->SetFont("vera", "", 8);
		$pdf->AddPage();
		$pdf->writeHTML($page, false, false, true, false, '');
	}
	
	//Close and output PDF document
	$pdf->Output("itinerary.pdf", "I");

	//============================================================+
	// END OF FILE                                                 
	//============================================================+
}

// Set  memory limit to its original
ini_set('memory_limit', $original_mem);
?>*/