<?
/** A PHP class to access SEO_STATUS table with convenient methods
  * in an object oriented way, and with a powerful debug system.\n
  * @version  1.0
  * @author   Juan Carlos Alvarez (juancarlos@costaricavirtual.com)
  */
// Include the class DB
if (!defined("TMS_ROOT")) {
die("TMS root path not defined");
}

include_once TMS_ROOT.'class/db/access.php';

class Leads {
    /**
     * holds all variables(properties) of an object
     *
     * @var array
     * @access protected
     */
    var $vars = array();

	/**
     * initialize SEO object
     * 
     * @access public
     * @param int $id index value
     */
    function Leads($id = null) {
		global $db;
	
		$this->initVar("id", -1);
		$this->initVar("website", -1);
		$this->initVar("formulaire", -1);
		$this->initVar("points", -1);
		$this->initVar("detail", -1);
		$this->initVar("form_date", -1);
		$this->initVar("form_time", -1);
		$this->initVar("agent", -1);
		$this->initVar("Customer_Id", -1);
		$this->initVar("status", -1);
		$this->initVar("Last_updated_by", -1);
		
		if (isset($id)) {
			if (intval($id) > 0) {
				$sql = 'SELECT * FROM `leads` WHERE `id`='.$id;
				$this->assignVars($db->queryUniqueArray($sql));
			}
		}
	}
	
	/**
     * initialize variables for the object
     *
     * @access public
     * @param string $key
     * @param mixed $value
     */
    function initVar($key, $value = null)
    {
        $this->vars[$key] = array('value' => $value);
    }
	
	/**
     * assign a value to a variable
     *
     * @access public
     * @param string $key name of the variable to assign
     * @param mixed $value value to assign
     */
    function assignVar($key, $value)
    {
        if (isset($key) && isset($this->vars[$key])) {
			if($key == 'detail') {
				$details = self::array_unserialize($value);
				$this->vars[$key]['value'] =& $details;
			} else {
				$this->vars[$key]['value'] =& $value;
			}
		}
    }

    /**
     * assign values to multiple variables in a batch
     *
     * @access private
     * @param array $var_array associative array of values to assign
     */
    function assignVars($var_arr)
    {
        foreach ($var_arr as $key => $value) {
            $this->assignVar($key, $value);
        }
    }
	
	/**
     * returns a specific variable for the object
     *
     * @access public
     * @param string $key key of the object's variable to be returned
     */
    function getVar($key)
    {
        $ret = null;
        if (!isset($this->vars[$key])) {
            return $ret;
        }
		$ret =  $this->vars[$key]['value'];
        return $ret;
	}
	
	/**
	* retrieve items from the database
	* 
	* @param string $criteria conditions to be met
	* @param string $groupBy order to be met
	* @param string $sortOrder order to be met
	* @return array array of objects 
	*/
	function &getObjects($criteria = '', $groupBy = '', $sortOrder = '')
	{
		global $db;
		$ret = false;
		$sql = 'SELECT * FROM `leads`';

		if ($criteria != '') {
			$sql .= " WHERE " . $criteria;
		}

		if ($groupBy != '') {
			$sql .= " GROUP BY " . $groupBy;
		}

		if ($sortOrder != '') {
			$sql .= ' ORDER BY '.$sortOrder;
		}
		
		$result = $db->query($sql);
		if (!$result) {
			return $ret;
		}
		
		$numrows = $db->numRows($result);
		if ($numrows == 0) {
			return $ret;
		}

		$theObjects = array();

		while ($myrow = $db->fetchNextArray($result)) {
			// hack for `Customer Id` field 
			$myrow['Customer_Id'] = $myrow['Customer Id'];
			unset($myrow['Customer Id']);
			// end hack
			$item = new Leads();
			$item->assignVars($myrow);

			$theObjects[$myrow['id']] =& $item;
			unset($item);
		}
		$ret = $theObjects;
		
		return $ret;
	}

	/**
	* insert items into the database table
	* 
	* @param array $values values to be added
	* @return nothing 
	*/
	function &putObjects($values = '')
	{
		global $db;
		$ret = false;
		$sql = 'INSERT INTO `leads`';

		if ($values == '') {
			return $ret;
		}
		// serialize detail array
		if (isset($values['detail'])) {
			$values['detail'] = self::array_serialize($values['detail']);
		}
		// set current date and time
		$values['form_date'] = date('Y-m-d');
		$values['form_time'] = date('H:i');
		// get keys and generates sql string
		$keys = array_keys($values);
		$sql .= " (`" . implode("`, `", $keys) . "`) VALUES ('" . implode("', '", $values) . "')";
		$db->execute($sql);
		$ret = $db->lastInsertedId();
		return $ret; 
	}
	
	/**
	* convert an array into a special serialized array
	*
	* @param array $item array with all form field ($_POST)
	* @return array 
	*/
	function array_serialize($item) {
		$ret = serialize($item);
		$ret = urlencode($ret);
		return $ret;
	}

	/**
	* convert a special serialized array into an un-serialized one
	*
	* @param array $item detail info from formulaires
	* @return array 
	*/
	function array_unserialize($item) {
		$ret = stripslashes($item);
		$ret = urldecode($ret);
		$ret = unserialize($ret);
		return $ret;
	}

}
