<?php 
    //header('Content-Type: text/xml; charset=ISO-8859-1');
    global $hostname, $database, $username, $password;
    include_once ("../include/functions.php");
    include_once ("../class/tmsFinance.php");

    // connect to soap on magento
    $proxy = new SoapClient('http://cart.absolutetravel-llc.com/api/soap/?wsdl');
    $sessionId = $proxy->login('TMS', 'em-thun.09');
    
    // read GET variables
    $actions = filter_input(INPUT_GET, 'a');
    $id = is_numeric($_GET['i']) ? $_GET['i']: 0;

    // Function traduce
    // parameters service string
    // return string
    function traduce($service) {
        switch ($service) {
            case 'Transfer':
                $service = 'Traslado';
                break;
            case 'Airline':
                $service = 'Aerol&iacute;nea';
                break;
            case 'Consolidator':
                $service = 'Consolidador';
                break;
            case 'Car Rental':
                $service = 'Rent-a-car';
                break;
            case 'School':
                $service = 'Escuela';
                break;
            case 'Guide':
                $service = 'Gu&iacute;a';
                break;
            case 'Rail':
                $service = 'Tren';
                break;
            case 'Tourism Office':
                $service = 'Oficina de Turismo';
                break;
            case 'Vacation Home':
                $service = 'Casa Vacacional';
                break;
            case 'Various':
                $service = 'Varios';
        }
        return $service;
    }

    switch ($actions) {
        case 'view':
            if($id > 0) {
                // Get product info
                echo '<pre>';
                print_r($proxy->call($sessionId, 'catalog_product.list', $id));
                echo '</pre>';
            } else {
                // View all products
                // $result = $proxy->call($sessionId, 'catalog_product.list');
                // var_dump($result);
                echo '<pre>';
                print_r($proxy->call($sessionId, 'catalog_product.list'));
                echo '</pre>';
            }
            break;
        
        case 'create':
            // read customer info
            $sql="SELECT `Customer Number` Customer_Number, Name, `Language` FROM customers WHERE `Customer Id` = ".$id;
            $customer = $db->queryUniqueObject($sql);
            // connect to tmsFinance
            $finance = new tmsFinance($id);
            // Carga las constantes segun el idioma
            if ( $customer->Language == 'Spanish' ) {
                include('../languages/es/rep1500.php');
            } else {
                include('../languages/en/rep1500.php');
            }
            // read itinerary info and create summary
            $sqlServices="SELECT `Vendor Name` Vendor, `Service Type` Service, `Internal Comments` Internal_Comments, `Type` FROM itineraries WHERE `Customer Id` = ".$id." AND `Service Type` <> 'Booking Engine' GROUP BY `Vendor Name` ORDER BY `Service Type`";
            $sqlBE = "SELECT `Internal Comments` `service` FROM itineraries WHERE `Customer Id` = ".$id." AND `Service Type` = 'Booking Engine' GROUP BY `Internal Comments`";
            $resultBE = $db->query($sqlBE);
            while($itinerary = $db->fetchNextObject($resultBE)) {
                $message .= HOTEL.$itinerary->service."<br>\n";
            }
            $result = $db->query($sqlServices);
            while($itinerary = $db->fetchNextObject($result)) {
                if(($itinerary->Vendor == 'Rail Source International' || $itinerary->Vendor == 'Railtour Suisse') && $rail == 'off') {
                    $message .= RAIL."<br>\n";
                    $rail = 'on';
                } elseif ($itinerary->Vendor == 'Magic Switzerland' || $itinerary->Vendor == 'MOB' ||
                        $itinerary->Vendor == 'Rhaetische Bahn' || $itinerary->Vendor == ' Rhaetische Bahn AG') {
                    $message .= "* ".$itinerary->Type."<br>\n";
                } else {
                    $servicio = $itinerary->Service;
                    if ( $language == 'Spanish' ) {
                        $servicio = traduce($itinerary->Service);
                    }
                    $message .= "* ".$servicio.": ".stripslashes($itinerary->Vendor)."<br>\n";
                }
            }
            // get attribute set
            $attributeSets = $proxy->call($sessionId, 'product_attribute_set.list');
            $attributeSet = current($attributeSets);
            // Create new product
            //$message
            //$price = money_format('%.2n',$finance->getTotalIncome());
            $price = $finance->getTotalIncome();
            $array2 = array(
                'categories' => array(2),
                'websites' => array(1),
                'name' => 'Custom Itinerary',
                'description' => $message,
                'short_description' => 'Custom Itinerary for '.$customer->Name,
                'weight' => '0',
                'status' => '1',
                'url_key' => $customer->Customer_Number.'-custom-itinerary',
                'url_path' => $customer->Customer_Number.'-custom-itinerary',
                'visibility' => '1',
                'price' => $price,
                'tax_class_id' => 0,
                'meta_title' => 'Custom Itinerary',
                'meta_keyword' => 'Custom Itinerary',
                'meta_description' => 'Custom Itinerary'
            );
            $array1 = array(
                'virtual', 
                $attributeSet['set_id'], 
                $customer->Customer_Number, 
                $array2
            );
            //echo '<pre>';
            //print_r($attributeSet);
            //echo '</pre>';
            $newProduct = $proxy->call($sessionId, 'catalog_product.create', &$array1);
            // Update TMS customer with magento product id
            $sql="UPDATE customers SET magento_product_id = ".$newProduct." WHERE `Customer Id` = ".$id."";
            $db->execute($sql);

            //var_dump ($result);
            $return = 'Product added to E-Commerce.';
            break;
        
        case 'delete':
            // Delete product
            $proxy->call($sessionId, 'catalog_product.delete', $id);
            break;
        
        case 'update';
            // Update customer
            $update = array('firstname' => 'Changed Firstname');
            $proxy->call($sessionId, 'customer.update', array($id, $update));
            break;

        default:
            break;
    }
    echo $return;
