<?php 
    //header('Content-Type: text/xml; charset=ISO-8859-1');
    global $hostname, $database, $username, $password;
    include_once '../include/functions.php';

	/*
	 * Function mg_catalog
     * parameters days_diff			integer (days before current date)
     * parameters status			string  (possible values: pending, processing, complete, cancelled, closed, onhold)
     * return array
	 */
	function mg_list_orders ($days_diff = 7, $status = 'complete') {
		// CONNECT TO MAGENTO VIA SOAP
		$proxy = new SoapClient('https://cart.absolutetravel-llc.com/api/soap/?wsdl');
		$sessionId = $proxy->login('TMS', 'em-thun.09');
		
		// GET CURRENT DATE
		$curYear=date("Y");
		$curMonth=date("m");
		$curDay=date("d");
		//$fromYear=($curMonth<3) ? $curYear-1: $curYear;
		//$fromMonth=($curMonth<3) ? $curMonth+10: $curMonth-2;
		
		// GENERATE DATES LIMITS
		$date_from = date("Y-m-d", mktime(0, 0, 0, $curMonth, $curDay - $days_diff, $curYear));
		$date_to = date("Y-m-d", mktime(0, 0, 0, $curMonth, $curDay+1, $curYear));
		
		// SEND COMMAND TO MAGENTO
		$magento = $proxy->call(
			$sessionId, 
			'sales_order.list', 
			array(
				array(
					'status'		=> array('eq'=>$status),
					'created_at'	=> array(
						'from'	=>$date_from,
						'to'	=>$date_to
					)
				)
			)
		);
		/* sample result
		[total_paid] => 4508.0000
		[customer_firstname] => Eileen
		[customer_lastname] =>  tetreault
		[created_at] => 2014-02-11 18:37:49
		*/
		
		// RETURN RESULT ARRAY
		$result['report_date_from'] = $date_from;
		$result['orders'] = $magento;
		return $result;
	}
