<?php
if ( isset($_GET["customer"]) ) {
	//include('./class/db/access.php');
	include('./include/functions.php');
	$lang = 'en';
	$mi_font = 'freeserif';
	if ( isset($_GET["lang"]) ) {
		include('./languages/'.$_GET["lang"].'/ccf.php');
	} else {
		include('./languages/'.$lang.'/ccf.php');
	}

	require_once('class/tcpdf4/config/lang/eng.php');
	require_once('class/tcpdf4/tcpdf.php');

	// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {	}
	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true); 
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	//$pdf->SetAuthor($customer->agent);
	$pdf->SetTitle(CCF_PDF_TITLE);
	$pdf->SetSubject(CCF_PDF_SUBJECT);
	$pdf->SetKeywords("magic, switzerland, europe, reservation, online");
	
	// set default header data
	$pdf->SetHeaderData('', '', '', '');
	
	// set header and footer fonts
	//$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	//$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
	
	//set margins
	$pdf->SetMargins(PDF_MARGIN_LEFT, 5, PDF_MARGIN_RIGHT);
	$pdf->SetHeaderMargin(0);
	$pdf->SetFooterMargin(0);
	
	//set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, 5);
	
	//set image scale factor
	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
	
	//set some language-dependent strings
	$pdf->setLanguageArray($l); 
	
	//initialize document
	$pdf->AliasNbPages();
	// add a page
	$pdf->AddPage();
	$pdf->SetFillColor(240,240,240);

/*		switch ($vendor->Country) {
			case "Guatemala":
				break;

			case "Panama":
				break;

			case "Belize":
				break;

			case "Costa Rica":
				break;
		}
*/		
	// ---------------------------------------------------------
	
	// set font
	$pdf->SetFont($mi_font, "B", 18);
	
	// print a line using Cell()
	$pdf->Cell(0,10,CCF_TITLE,0,1,'C');

	// header 1
	$text = "This form will NOT send your credit card information over the Internet. It will simply allow you to print a filled in authorization form. Please don't forget to sign it and then fax it to us. Credit Card companies in Central America operate under different regulations and require that we have your signature on file.";
	$pdf->SetFont($mi_font, "", 7);
	$pdf->MultiCell(0,6,sprintf(CCF_WARNING1,COMPANY_FAX),0,'C',0,1,'','',true,0,true);

	// header 2
	$pdf->SetFont($mi_font, "B", 7);
	$pdf->MultiCell(0,3,sprintf(CCF_WARNING2,COMPANY_NAME_REAL),0,'C',0,1,'','',true,0,true);

	// TABLE HEADER
	$pdf->SetFont($mi_font, "B", 9);
	$pdf->Cell(26,6,CCF_DATE,"LT",0,'C',1);
	$pdf->Cell(149,6,CCF_DESCRIPTION,"LT",0,'C',1);
	$pdf->Cell(20,6,CCF_AMOUNT,"LTR",1,'C',1);

	// Lee el itinerario correspondiente
	$sql="SELECT `Service Type` Service_Type, `Vendor Name` Vendor_Name, 
		DATE_FORMAT(`From Date`,'%b %d, %Y') From_Date, DATE_FORMAT(`To Date`,'%b %d, %Y') To_Date,
		`Number of Days` Days, i.QTY QTY, Size, `Type`, `Comment`, `Amount Confirmed` Amount,
		i.`Price Id` Price_Id, 
		c.`Last updated by` agent, procfeepc feepc, procfee fee, subtotal, Discountpc, Discount, 
		c.`Customer Number` Customer_Number, c.Markup Markup, c.`Markup TA` muta, 
		c.`Add Markup` addMarkup, i.`Rack Rate` Rack_Rate, `Referred by` Website, i.`Internal Comments` Internal_Comments 
	FROM itineraries i, customers c
	WHERE i.`Customer Id` = ".$_GET["customer"]." AND c.`Customer Id` = ".$_GET["customer"].
		" AND `CCF Sent` = 0 AND (i.`Payment Ref #` = '' OR i.`Payment Ref #` IS NULL)
	ORDER BY `From Date`, `To Date`";
	$result=$db->query($sql);
	//echo "sql:".$sql."<br>";
	$chars_line = 115;
	$min_height = 7;
	$line_height = 3.5;
	while ($itinerary = $db->fetchNextObject($result)) { 
		// lee los price comments
		$sql_comm="SELECT Price_Comments FROM prices 
			WHERE Price_Id = ".$itinerary->Price_Id."";
		$itinerary_Price_Comments = $db->queryUniqueValue($sql_comm);
		// dias o noches
		$fecha_hora=date('F j, Y - g:i a');
		$contenido = '';
		$days_nights = ($itinerary->Service_Type=="Hotel" || $itinerary->Service_Type=="Booking Engine" || $itinerary->Service_Type=="Bed & BreakFast") ? CCF_NIGHT : CCF_DAY;
		// Contenido
		switch ($itinerary->Service_Type) {
			case "Hotel":
			case "Bed & BreakFast":
				$contenido = $itinerary->Days.$days_nights;
				$contenido .= " at ".stripslashes($itinerary->Vendor_Name).". ";
				$contenido .= stripslashes($itinerary->QTY)." ".stripslashes($itinerary->Size)." ".stripslashes($itinerary->Type).". ";
				break;

			case "Booking Engine":
				$contenido = $itinerary->Days.$days_nights;
				$contenido .= " at ".stripslashes($itinerary->Internal_Comments).". ";
				$contenido .= stripslashes($itinerary->QTY)." ".stripslashes($itinerary->Size)." ".stripslashes($itinerary->Type).". ";
				// cambia los price comments por comment
				$itinerary_Price_Comments = $itinerary->Comment;
				break;

			case "Transfer":
			case "Airline":
			case "Consolidator":
			case "Tour":
				$sql_cat="SELECT Price_Category FROM prices 
					WHERE Price_Id = ".$itinerary->Price_Id."";
				$itinerary_Category = $db->queryUniqueValue($sql_cat);				
				$contenido = stripslashes($itinerary->QTY)." ".$itinerary->Size." ".stripslashes($itinerary->Type)." ".stripslashes($itinerary_Category).". ";
				break;

			case "Car Rental":
				$sql_cat="SELECT Price_Category FROM prices 
					WHERE Price_Id = ".$itinerary->Price_Id."";
				$itinerary_Category = $db->queryUniqueValue($sql_cat);				
				$contenido = stripslashes($itinerary->QTY)." ".$itinerary->Size." ".stripslashes($itinerary->Type)." ".stripslashes($itinerary_Category).". ";
				break;
		}
		$contenido .= CCF_COMMENT.stripslashes($itinerary_Price_Comments);
		//$contenido .= "Comments: ".stripslashes($itinerary->Comment);
		//$contenido .= "Taxes: ".stripslashes($itinerary->Taxes);

		// TABLE CONTENT
		$len_text = strlen($contenido);
		$cell_height = ceil($len_text / $chars_line) * $line_height;
		$h = ($cell_height > $min_height) ? $cell_height : $min_height;
		
		$pdf->SetFont($mi_font, "", 7);
		$fecha = CCF_FROM.$itinerary->From_Date.CCF_TO.$itinerary->To_Date;
		$pdf->MultiCell(26,$h,$fecha,"LT",'L',0,0,'','',true,0,true);
		$pdf->MultiCell(149,$h, char_decode($contenido),"LT",'L',0,0,'','',true,0,true);
		
		// Si es un cliente de agencia no pone los montos de los servicios
		if ($itinerary->muta == 0 AND !isset($_GET["prices"]))
			$pdf->MultiCell(20,$h,"$".money_format('%.2n',$itinerary->Amount/$itinerary->Rack_Rate),"LTR",'R',0,1,'','',true,0,true);
		else
			$pdf->MultiCell(20,$h,"","LTR",'R',0,1,'','',true,0,true);
		
		$subtotal = $itinerary->subtotal+$itinerary->Markup;
		$discountpc = ($itinerary->Discountpc>0) ? $itinerary->Discountpc.'% ': '';
		$discount = $itinerary->Discount;
		$addMarkup = $itinerary->addMarkup;
		$fee = $itinerary->fee;
		$feepc = ($itinerary->feepc>0) ? $itinerary->feepc.'% ': '';
		$agente = $itinerary->agent;
		$numero = $itinerary->Customer_Number;
		$muta = $itinerary->muta;
		$Website = $itinerary->Website;
		if($Website=='MCH' OR $Website=='MAU' OR $Website=='MFR') {
			$myName = "Enjoy Central America S.A. dba Magic Switzerland";
			$mylogo = "magic.jpg";
			$mywidth = 55;
			$myheight = 16;
		} else {
			$myName = "Enjoy Central America S.A.";
			$mylogo = "logo.jpg";
			$mywidth = 40;
			$myheight = 24;
		}
		if ($itinerary->muta > 0) {
			$subtotal = $itinerary->subtotal+$itinerary->Markup-$discount+$muta;
			$discountpc = $discount = 0;
		}
	} // fin del while

	// Borde superior de los totales
	$borde = 'T';
	if($Website != 'MCH' AND $Website != 'MAU' AND $Website != 'MFR' AND $Website != 'MEU') {
		$borde = '';
		// TABLE SUBTOTALS
		$pdf->SetFont($mi_font, "B", 9);
		$pdf->Cell(175,5,CCF_SUBTOTAL,"LT",0,'R');
		$pdf->SetFont($mi_font, "", 9);
		$pdf->Cell(20,5,"$".money_format('%.2n',$subtotal),"LTR",1,'R');
	
		if($discount > 0 || $discountpc > 0){
			$pdf->SetFont($mi_font, "B", 9);
			$pdf->Cell(100,5,"","L",0,'L');
			$pdf->Cell(75,5,$discountpc.CCF_DISCOUNT,0,0,'R');
			$pdf->SetFont($mi_font, "", 9);
			$pdf->Cell(20,5,"$-".money_format('%.2n',$discount),"LTR",1,'R');
		}
	
		if($addMarkup > 0){
			$pdf->SetFont($mi_font, "B", 9);
			$pdf->Cell(100,5,"","L",0,'L');
			$pdf->Cell(75,5,CCF_ADDMARKUP,0,0,'R');
			$pdf->SetFont($mi_font, "", 9);
			$pdf->Cell(20,5,"$".money_format('%.2n',$addMarkup),"LTR",1,'R');
		}
		
		$msj_proc_fee = CCF_PROC_FEE;
		/* */
		if($Website == 'EPA' OR $Website == 'PAV') {
			$msj_proc_fee = CCF_PROC_FEE_PA;
		}
		/* */
		$pdf->SetFont($mi_font, "B", 9);
		$pdf->Cell(175,5,$feepc.$msj_proc_fee,"L",0,'R');
		$pdf->SetFont($mi_font, "", 9);
		$pdf->Cell(20,5,"$".money_format('%.2n',$fee),"LTR",1,'R');
	} // endif website = Magic
	$pdf->SetFont($mi_font, "B", 9);
	$pdf->Cell(100,5,$agente." / ".$numero,"LB".$borde,0,'L');
	$pdf->Cell(75,5,CCF_TOTAL,"B".$borde,0,'R');
	$pdf->SetFont($mi_font, "", 9);
	$pdf->Cell(20,5,"$".money_format('%.2n',$subtotal-$discount+$addMarkup+$fee),"LTRB",1,'R');

	// add page
	//$pdf->AddPage();

	// no show policy
	$pdf->SetFont($mi_font, "B", 7);
	$pdf->Cell(0,3,CCF_NO_SHOW,0,1,'L');
	$pdf->SetFont($mi_font, "", 7);
	$pdf->MultiCell(0,18,CCF_NO_SHOW_DESC1.CCF_NO_SHOW_DESC2,0,'L',0,1,'','',true,0,true);

	//$pdf->SetFont($mi_font, "", 7);
	//$pdf->MultiCell(0,3,CCF_CHARGED,0,'C',0,1);

	// authorize
	$pdf->SetFont($mi_font, "B", 7);
	$pdf->MultiCell(0,6,sprintf(CCF_AUTHORIZE,COMPANY_NAME_REAL,COUNTRY,COMPANY_NAME,COMPANY_NAME_REAL),0,'C',0,1);

	// form to fill
	$pdf->Cell(32,5,CCF_CCNUMBER,"LT",0,'R');
	$pdf->Cell(93,5,"","T",0,'L');
	$pdf->Cell(40,5,CCF_VALID_DATE,"T",0,'L');
	$pdf->Cell(30,5,CCF_CVV2,"TR",1,'L');
	$pdf->Cell(32,5,CCF_CCNAME,"LT",0,'R');
	$pdf->Cell(93,5,"","T",0,'L');
	$pdf->Cell(70,5,CCF_CCPHONE,"TR",1,'L');

	$pdf->MultiCell(120,15,CCF_CCADDRESS,"LT",'L',0,0);
	$pdf->MultiCell(75,15,CCF_CCSIGN1,"LTR",'L',0,1);
	$pdf->Cell(120,7,"","LB",0,'L');
	$pdf->Cell(75,7,CCF_CCSIGN2,"LBR",1,'C');

	// footer
	$sql = "SELECT Description FROM `list box text` 
		WHERE `List Box Name`='Sites' AND `List Box Text`='".$Website."'";
	$Website = $db->queryUniqueValue($sql);
	$pdf->SetFont($mi_font, "B", 7);
	//$pdf->Cell(0,4,$Website.sprintf(CCF_SERVICE,$myName),0,1,'C');
	$pdf->MultiCell(0,4,sprintf(CCF_FOOTER1,COMPANY_NAME_REAL),0,'C',0,1,'','',true,0,true);
	//$pdf->Cell(0,4,sprintf(CCF_FOOTER1,COMPANY_NAME_REAL),0,1,'C');
	$pdf->SetFont($mi_font, "B", 8);
	$pdf->MultiCell(0,4,sprintf(CCF_FAXTHIS,COMPANY_NAME_REAL,COMPANY_ADDRESS,COMPANY_CITY,COMPANY_POBOX,COMPANY_TEL,COMPANY_FAX),0,'C',0,1,'','',true,0,true);
	//$pdf->Cell(0,4,sprintf(CCF_FAXTHIS,COMPANY_NAME_REAL,COMPANY_ADDRESS,COMPANY_CITY,COMPANY_POBOX,COMPANY_TEL,COMPANY_FAX),0,1,'C');
	$pdf->MultiCell(0,4,sprintf(CCF_FOOTER2,2012,COMPANY_NAME_REAL),0,'C',0,1,'','',true,0,true);
	//$pdf->Cell(0,4,sprintf(CCF_FOOTER2,2012,COMPANY_NAME_REAL),0,1,'C');
	//$pdf->writeHTMLCell(0,4,$pdf->GetX(),$pdf->GetY(),CCF_SQUAREMOUTH,0,1,0,true,'C');
	//writeHTMLCell( float $w, float $h, float $x, float $y, [string $html = ''], [mixed $border = 0], [int $ln = 0], [int $fill = 0], [boolean $reseth = true], [string $align = ''], [boolean $autopadding = true])


	$pdf->Image(K_PATH_IMAGES.$mylogo,"",$pdf->GetY(),$mywidth,$myheight,"","","",false,300,"C");

/**/
	// Before print PDF update table itineraries to set as sent each service
	//$sql="UPDATE itineraries SET `CCF Sent` = 1 WHERE `Customer Id` = ".$_GET["customer"]." AND `CCF Sent` = 0";
	//$db->execute($sql);
	
	//Close and output PDF document
	$pdf->Output("ccf.pdf", "I");

	//============================================================+
	// END OF FILE                                                 
	//============================================================+
}
?>