<?php
if ( isset($_GET["from"]) && isset($_GET["to"]) ) {
    header('Content-Type: text/xml; charset=ISO-8859-1');
    include('./include/functions.php');
    $sql="SELECT CONCAT(firstname, ' ', lastname) nombre, `group` FROM users_users 
        WHERE username = '".$_SERVER['REMOTE_USER']."'";
    $usuario = $db->queryUniqueObject($sql);
    $tablas = '';
    $criterios = '';
    if($usuario->group == "Accounting") {
        $tablas = ", vendors v, users_users u";
        $criterios = "CONCAT(u.firstname, ' ', u.lastname) = '".$usuario->nombre."' AND i.`Vendor Id` = v.`Vendor Id` 
        AND u.targets REGEXP v.Country AND ";
    }
    if($usuario->group == "Sales") {
        $criterios = "c.`Last updated by` LIKE '%".$usuario->nombre."%' AND ";
    }

    $sql="SELECT DATE_FORMAT(i.`To Date`, '%d.%b.%y') ToDate, DATE_FORMAT(i.`To Date`, '%M') Mes, 
        DATE_FORMAT(i.`To Date`, '%Y') Year, c.`Last updated by` Agent, c.`Customer Number` custNumber, 
        c.`Customer Id` custId, c.Name Customer, COUNT(i.`Ok to Pay`) - SUM(i.`Ok to Pay`) Pay, 
        (c.`subtotal`+c.`Markup`+c.`Add Markup`+c.`procfee`-c.`Discount`-c.`Client credit`) Income
    FROM customers c, itineraries i".$tablas."
    WHERE ".$criterios."(c.`Visit Status` = 'success' OR c.`Visit Status` = 'customer' OR 
        c.`Visit Status` = 'interested' OR c.`Visit Status` = 'prospect') AND c.`Customer Id` = i.`Customer Id` 
        AND i.`To Date` >= '".$_GET["from"]."' AND i.`To Date` <= '".$_GET["to"]."' AND 
        i.`Reservation Confirmed` = 1
    GROUP BY i.`Customer Id` ORDER BY i.`To Date`, c.Name";
    $result=$db->query($sql);

    //echo "sql:".$sql."<br>";
    require_once('class/tcpdf4/config/lang/eng.php');
    require_once('class/tcpdf4/tcpdf.php');

    // Extend the TCPDF class to create custom Header and Footer
    class MYPDF extends TCPDF {
    }
    // create new PDF document
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true); 

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor($usuario->nombre);
    $pdf->SetTitle(COMPANY_NAME." Departure Report");
    $pdf->SetSubject("Departure by Month ".COMPANY_NAME);
    $pdf->SetKeywords("magic, switzerland, europe, reservation, online");
    $pdf->setPrintFooter(false);

    // set default header data
    $pdf->SetHeaderData('Enjoy-Magic2.jpg', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, '');

    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(0);

    //set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, 5);

    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 

    //set some language-dependent strings
    $pdf->setLanguageArray($l); 

    //initialize document
    $pdf->AliasNbPages();
    // add a page
    $pdf->AddPage();
    $pdf->SetFillColor(240,240,240);
    // Print Page Title
    $pdf->Ln();
    $pdf->SetFont("vera", "B", 18);
    $pdf->Cell(0,12,"DEPARTURE REPORT",0,1,'C');

    // Print Subtitles
    $pdf->SetFont("vera", "", 13);
    $pdf->Cell(0,12,"From ".$_GET["from"]." to ".$_GET["to"],0,1,'C');

    if($usuario->group != "Sales") {
        $linewidth = 180;
    } else {
        $linewidth = 150;
    }

    // ---------------------------------------------------------
    //$pdf->Ln();
    $mes = '';
    $totalmes = $totalperiodo = 0;
    while ($visit = $db->fetchNextObject($result)) { 
        if ($mes != $visit->Mes) {
            if ($totalmes > 0) {
                $pdf->SetFont("vera", "B", 8);
                $pdf->Cell($linewidth-30,5,"Month Totals: ",'T',0,'R');
                $pdf->Cell(30,5,$totalmes,'T',1,'R');
                $pdf->Ln();
            }

            // Set values
            $mes = $visit->Mes;
            $totalmes = 0;

            // Print Month
            $pdf->SetFont("vera", "", 14);
            $pdf->Cell($linewidth,7,'Month '.$mes.', '.$visit->Year,0,1,'L');

            // Print Cols titles
            $pdf->SetFont("vera", "", 8);
            if($usuario->group != "Sales") {
                $pdf->Cell(30,5,"Agent",'B',0,'C');
            }
            $pdf->Cell(20,5,"Departure",'B',0,'C');
            $pdf->Cell(100,5,"Customer",'B',0,'L');
            $pdf->Cell(15,5,"Pay",'B',0,'C');
            $pdf->Cell(15,5,"Income $",'B',1,'C');
        }
        // Calculate totals
        $totalmes += $visit->Income;
        $totalperiodo += $visit->Income;

        // print detail
        $customer_link = "<a href='".TMS."customers.php?customer=".$visit->custId."'>".$visit->custNumber."</a> - ".$visit->Customer;
        $pay = ($visit->Pay==0) ? 'Yes' : '** No **';
        $pdf->SetFont("vera", "", 8);
        if($usuario->group != "Sales") {
                $pdf->Cell(30,5,$visit->Agent,0,0,'L');
        }
        $pdf->Cell(20,5,$visit->ToDate,0,0,'C');
        $pdf->Cell(100,5,$visit->custNumber." - ".$visit->Customer,0,0,'L');
        //$pdf->Cell(100,5,$customer_link,0,0,'L');
        //$pdf->writeHTMLCell( 100, 5, '', '', $customer_link, 0, 0, 0, 0, 'L', 0);
        $pdf->Cell(15,5,$pay,0,0,'C');
        $pdf->Cell(15,5,money_format('%.2n',$visit->Income),0,1,'R');
    } // fin del while
    $pdf->SetFont("vera", "B", 8);
    $pdf->Cell($linewidth-30,5,"Month Totals: ",'T',0,'R');
    $pdf->Cell(30,5,money_format('%.2n',$totalmes),'T',1,'R');
    $pdf->Ln();
    $pdf->SetFont("vera", "", 14);
    $pdf->Cell(45,7,"Grand Totals US$ ",0,0,'L');
    $pdf->Cell(25,5,money_format('%.2n',$totalperiodo),0,1,'L');

    //Close and output PDF document
    $pdf->Output("departure-sales.pdf", "I");
    //============================================================+
    // END OF FILE                                                 
    //============================================================+
}
?>