<?php
if ( isset($_GET["customer"]) && isset($_GET["submit"]) ) {
	include('./include/functions.php');
	include('./include/definitions.php');
	$sql="SELECT `Customer Number` Number, Name, `Last updated by` agent, 
		`Referred by` Site, procfeepc, procfee, Discount, Discountpc, Email, Phone, 
		`Add Markup` addMarkup, `Add Markup pc` addMarkuppc 
		FROM customers WHERE `Customer Id` = ".$_GET["customer"];
	$customer= $db->queryUniqueObject($sql);
	
	$sql="SELECT email, country FROM users_users WHERE CONCAT(firstname, ' ', lastname) = '".$customer->agent."'";
	$usuario= $db->queryUniqueObject($sql);

	$sql="SELECT `Vendor Name` Vendor_Name, `Service Type` Service_Type, DATE_FORMAT(`From Date`, '%d.%b.%y') From_Date, DATE_FORMAT(`To Date`, '%d.%b.%y') To_Date, `Number of Days` Number_of_Days, `Confirmation #` confirmation, PAX, QTY, Size, `Type`, `Price Rack` Net, `Amount Confirmed` Confirmed, `Amount Billed` NetTax, DATE_FORMAT(`Payment Due Date`, '%d.%b.%y') Payment_Date, `Amount Paid` Paid, DATE_FORMAT(`Date Paid`, '%d.%b.%y') Date_Paid, `Payment Ref #` Payment_Ref, `Rack Rate` rackRate, `Net Rate` netRate, `Rack Currency` rackCur, `Net Currency` netCur, `Vendor Id` Vendor_Id, `Price Id` Price_Id, `Internal Comments` InternalComments 
	FROM itineraries WHERE `Customer Id` = ".$_GET["customer"].
		" ORDER BY `From Date`, `To Date`";
	$result=$db->query($sql);
	
	//echo "sql:".$sql."<br>";
	require_once('class/tcpdf4/config/lang/eng.php');
	require_once('class/tcpdf4/tcpdf.php');

	// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {
	}
	// create new PDF document
	$pdf = new MYPDF("L", PDF_UNIT, PDF_PAGE_FORMAT, true); 
	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($customer->agent);
	$pdf->SetTitle(COMPANY_NAME." Customer Itinerary Summary");
	$pdf->SetSubject("Customer Itinerary Summary by ".COMPANY_NAME);
	$pdf->SetKeywords("magic, switzerland, europe, reservation, online");
	$pdf->setPrintFooter(false);
	
	// set default header data
	//$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
	
	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
	
	//set margins
	$pdf->SetMargins(PDF_MARGIN_LEFT, 15, PDF_MARGIN_RIGHT);
	$pdf->SetHeaderMargin(0);
	$pdf->SetFooterMargin(0);
	
	//set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	
	//set image scale factor
	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
	
	//set some language-dependent strings
	$pdf->setLanguageArray($l); 
	
	//initialize document
	$pdf->AliasNbPages();
	// add a page
	$pdf->AddPage();
	$pdf->SetFillColor(240,240,240);
	// Print Page Title
	$pdf->SetFont("vera", "B", 18);
	$pdf->Cell(0,18,"Customer Itinerary Summary",0,1,'C');

	// Print Customer and Agent Info
	$pdf->SetFont("vera", "", 10);
	$pdf->Cell(30,5,"Customer #",0,0,'R');
	$pdf->SetFont("vera", "B", 10);
	$pdf->Cell(40,5,$customer->Number,0,0,'L');
	$pdf->SetFont("vera", "", 10);
	$pdf->Cell(20,5,"Name",0,0,'R');
	$pdf->SetFont("vera", "B", 10);
	$pdf->Cell(70,5,$customer->Name,0,0,'L');
	$pdf->SetFont("vera", "", 10);
	$pdf->Cell(20,5,"Referred by",0,0,'R');
	$pdf->SetFont("vera", "B", 10);
	$pdf->Cell(45,5,$customer->Site,0,1,'L');

	$pdf->SetFont("vera", "", 10);
	$pdf->Cell(30,5,"Phone",0,0,'R');
	$pdf->SetFont("vera", "B", 10);
	$pdf->Cell(40,5,$customer->Phone,0,0,'L');
	$pdf->SetFont("vera", "", 10);
	$pdf->Cell(20,5,"Email",0,0,'R');
	$pdf->SetFont("vera", "B", 10);
	$pdf->Cell(70,5,$customer->Email,0,0,'L');
	$pdf->SetFont("vera", "", 10);
	$pdf->Cell(20,5,"Agent",0,0,'R');
	$pdf->SetFont("vera", "B", 10);
	$pdf->Cell(45,5,$customer->agent,0,1,'L');
	// ---------------------------------------------------------
	$pdf->Ln();
	$ConfirmedTotal = $NetTaxTotal = $ConfirmedTotalG = $NetTaxTotalG = 0;

	// print headers
	$pdf->SetFont("vera", "", 8);
	//int MultiCell( float $w, float $h, string $txt, [mixed $border = 0], [string $align = 'J'], [int $fill = 0], [int $ln = 1], [int $x = ''], [int $y = ''], [boolean $reseth = true], [int $stretch = 0], [boolean $ishtml = false])
	$pdf->MultiCell(70,9,"Vendor Name",'B','C',0,0);
	$pdf->MultiCell(17,9,"From Date",'B','C',0,0);
	$pdf->MultiCell(17,9,"To Date",'B','C',0,0);

	// void Cell( float $w, [float $h = 0], [string $txt = ''], [mixed $border = 0], [int $ln = 0], [string $align = ''], [int $fill = 0], [mixed $link = ''], [int $stretch = 0])
	$pdf->MultiCell(13,9,"days nights",'B','C',0,0);
	$pdf->MultiCell(8,9,"PAX",'B','C',0,0);
	$pdf->MultiCell(8,9,"Qty.",'B','C',0,0);
	//$pdf->MultiCell(17,9,"Type",'B','C',0,0);
	$pdf->MultiCell(27,9,"Confirm. by",'B','C',0,0);
	$pdf->MultiCell(17,9,"Rack Unit",'B','C',0,0); //NET
	$pdf->MultiCell(17,9,"Rack Total",'B','C',0,0);
	$pdf->MultiCell(17,9,"Net Total",'B','C',0,0);  //NET +taxes
	//$pdf->MultiCell(17,9,"Payment Due Date",'B','C',0,0);
	$pdf->MultiCell(17,9,'Amount Paid','B','C',0,0);
	$pdf->MultiCell(17,9,"Date Paid",'B','C',0,0);
	$pdf->MultiCell(17,9,"Payment Ref.",'B','C',0,1);
	//$pdf->MultiCell(17,9,"NET Profit",'B','C',0,0);
	//$pdf->MultiCell(12,9,"Factor",'B','C',0,1);

	while ($itinerary = $db->fetchNextObject($result)) {
		$sql="SELECT Country, Location, Telephone, `Exact Address` Address, 
			`Quick Search Text` Quick FROM vendors WHERE `Vendor Id` = ".$itinerary->Vendor_Id;
		$vendor = $db->queryUniqueObject($sql);
		$vendorName = $itinerary->Vendor_Name;
		if ($itinerary->Service_Type=='Booking Engine') {
			if ($itinerary->Price_Id > 0){
				$sql="SELECT Comments FROM prices WHERE Price_Id = ".$itinerary->Price_Id;
				$vendorName = $db->queryUniqueValue($sql) . "\n".' * '.$vendorName;
			} else {
				$vendorName = stripslashes($itinerary->InternalComments) . "\n".' * '.$vendorName;
			}
		}
 
		$days_nights = ($itinerary->Service_Type=="Hotel" || $itinerary->Service_Type=="Bed & BreakFast") ? 'Nights' : 'Days';
		// calc totals
		$ConfirmedTotal += ($itinerary->Confirmed/$itinerary->netRate);
		$NetTaxTotal += ($itinerary->NetTax/$itinerary->netRate);
		// print detail
		$pdf->SetFont("vera", "", 8);
		$pdf->MultiCell(70,9,$vendorName,0,'L',1,0);
		$pdf->MultiCell(17,9,$itinerary->From_Date,0,'L',0,0);
		$pdf->MultiCell(17,9,$itinerary->To_Date,0,'L',1,0);
		$pdf->MultiCell(13,9,$itinerary->Number_of_Days,0,'C',0,0);
		$pdf->MultiCell(8,9,$itinerary->PAX,0,'C',1,0);
		$pdf->MultiCell(8,9,$itinerary->QTY,0,'C',0,0);
		//$pdf->MultiCell(17,9,$itinerary->Type,0,'L',1,0);
		$pdf->MultiCell(27,9,$itinerary->confirmation,0,'L',0,0);
		$pdf->MultiCell(17,9,money_format('%.2n',$itinerary->Net/$itinerary->rackRate),0,'R',1,0);
		$pdf->Image($_SERVER['DOCUMENT_ROOT'].'/system/images/icons/money_'.$itinerary->rackCur.'.png',$pdf->GetX(),$pdf->GetY(),4.74,4.74);
		$pdf->MultiCell(17,9,money_format('%.2n',$itinerary->Confirmed/$itinerary->rackRate),0,'R',0,0);
		$pdf->Image($_SERVER['DOCUMENT_ROOT'].'/system/images/icons/money_'.$itinerary->rackCur.'.png',$pdf->GetX(),$pdf->GetY(),4.74,4.74);
		$pdf->MultiCell(17,9,money_format('%.2n',$itinerary->NetTax/$itinerary->netRate),0,'R',1,0);
		//$pdf->MultiCell(17,9,$itinerary->Payment_Date,0,'L',0,0);
		$pdf->MultiCell(17,9,money_format('%.2n',$itinerary->Paid),0,'R',1,0);
		$pdf->MultiCell(17,9,$itinerary->Date_Paid,0,'L',0,0);
		$pdf->MultiCell(17,9,$itinerary->Payment_Ref,0,'L',1,1);
		//$pdf->MultiCell(17,9,money_format('%.2n',$itinerary->Confirmed-$itinerary->NetTax),0,'R',0,0);
		//$pdf->MultiCell(12,9,money_format('%.2n',$itinerary->NetTax/$itinerary->Confirmed),0,'R',1,1);
	} // fin del while

	// Print Last Subtotal
	$pdf->SetFont("vera", "", 8);
	$pdf->Cell(126,4,"SubTotals for: ",'T',0,'R');
	$pdf->SetFont("vera", "B", 8);
	$pdf->Cell(34,4,$service,'T',0,'L');
	$pdf->Cell(17,4,money_format('%.2n',$ConfirmedTotal),'T',0,'R');
	$pdf->Cell(17,4,money_format('%.2n',$NetTaxTotal),'T',0,'R');
	$pdf->Cell(68,4,'','T',1,'R');
	//$pdf->Cell(17,5,money_format('%.2n',$ConfirmedTotal-$NetTaxTotal),'T',0,'R');
	//$pdf->Cell(12,5,money_format('%.2n',$NetTaxTotal/$ConfirmedTotal),'T',1,'R');
	//$pdf->Ln();
	$ConfirmedTotalG += $ConfirmedTotal;
	$NetTaxTotalG += $NetTaxTotal;

	// Discount
	if($customer->Discount > 0){
		$ConfirmedTotalG -= $customer->Discount;
		// Print Discount
		$pdf->SetFont("vera", "", 8);
		$pdf->Cell(126,4,"",0,0,'R');
		$pdf->Cell(34,4,"Discount: (".$customer->Discountpc."%)",0,0,'R');
		$pdf->SetFont("vera", "B", 8);
		$pdf->Cell(17,4,'-'.money_format('%.2n',$customer->Discount),0,1,'R');
	}

	// Additional Markup
	if($customer->addMarkup > 0){
		$ConfirmedTotalG += $customer->addMarkup;
		// Print Discount
		$pdf->SetFont("vera", "", 8);
		$pdf->Cell(126,4,"",0,0,'R');
		$pdf->Cell(34,4,"Additional: (".$customer->addMarkuppc."%)",0,0,'R');
		$pdf->SetFont("vera", "B", 8);
		$pdf->Cell(17,4,money_format('%.2n',$customer->addMarkup),0,1,'R');
	}
	
	// Print Processing Fee
	$pdf->SetFont("vera", "", 8);
	$pdf->Cell(126,4,"",0,0,'R');
	$pdf->Cell(34,4,"Processing Fee: (".$customer->procfeepc."%)",0,0,'R');
	$pdf->SetFont("vera", "B", 8);
	$pdf->Cell(17,4,money_format('%.2n',$customer->procfee),0,1,'R');
	$ConfirmedTotalG += $customer->procfee;
	// Print Grand Total
	$pdf->SetFont("vera", "", 8);
	$pdf->Cell(126,4,"",'T',0,'R');
	$pdf->Cell(34,4,"Grand Totals: ",'T',0,'R');
	$pdf->SetFont("vera", "B", 8);
	$pdf->Cell(17,4,money_format('%.2n',$ConfirmedTotalG),'T',0,'R');
	//$pdf->Cell(17,5,money_format('%.2n',$NetTaxTotalG),'T',0,'R');
	$pdf->Cell(85,4,'','T',1,'R');
	//$pdf->Cell(17,5,money_format('%.2n',$ConfirmedTotalG-$NetTaxTotalG),'T',0,'R');
	//$pdf->Cell(12,5,money_format('%.2n',$NetTaxTotalG/$ConfirmedTotalG),'T',1,'R');
	$pdf->Ln();
	$pdf->Ln();

	// Credit Card Charge
	$pdf->SetFont("vera", "", 15);
	$pdf->Cell(150,7,'Panel Charges',0,1,'L');

	$pdf->SetFont("vera", "", 8);
	$pdf->MultiCell(30,5,'Date','B','C',0,0);
	$pdf->MultiCell(30,5,'Amount','B','C',0,0);
	$pdf->MultiCell(30,5,'Factor','B','C',1,1);

	$sql = "SELECT A.monto abono, P.factor factor, A.fecha cobrado
	FROM $dbpanel.pagos P, $dbpanel.abonos A 
	WHERE P.CustomerId = '".$customer->Number."' AND P.id_pago = A.pago";
	$result=$db->query($sql);
	$balance = $ConfirmedTotalG;
	while ($transactions = $db->fetchNextObject($result)) { 
		$balance -= $transactions->abono;
		$pdf->SetFont("vera", "", 8);
		$pdf->Cell(30,9,$transactions->cobrado,0,0,'L');
		$pdf->Cell(30,9,money_format('%.2n',$transactions->abono),0,0,'R');
		$pdf->Cell(30,9,money_format('%.2n',$transactions->factor),0,1,'R');
	}
	$pdf->SetFont("vera", "", 8);
	$pdf->Cell(30,4,'Balance','T',0,'R');
	$pdf->Cell(30,4,'US$ '.money_format('%.2n',$balance),'T',0,'R');
	$pdf->Cell(30,4,'','T',1,'R');

	//Close and output PDF document
	$pdf->Output("itinerary.pdf", "I");

	//============================================================+
	// END OF FILE                                                 
	//============================================================+
}
?>