<?php
if ( isset($_GET["from"]) && isset($_GET["to"]) ) {
    header('Content-Type: text/xml; charset=ISO-8859-1');
    include('./include/functions.php');
    $sql="SELECT CONCAT(firstname, ' ', lastname) as nombre, `group` FROM users_users 
        WHERE username = '".$_SERVER['REMOTE_USER']."'";
    $usuario = $db->queryUniqueObject($sql);
    $tablas = '';
    $criterios = '';
    if($usuario->group == "Accounting") {
        $tablas = ", vendors v, users_users u";
        $criterios = "CONCAT(u.firstname, ' ', u.lastname) = '".$usuario->nombre."' AND i.`Vendor Id` = v.`Vendor Id` 
        AND u.targets REGEXP v.Country AND ";
    }
    if($usuario->group == "Sales") {
        $criterios = "c.`Last updated by` LIKE '%".$usuario->nombre."%' AND ";
    }

    $sql="SELECT DATE_FORMAT(i.`From Date`, '%d.%b.%y') as FromDate, c.`Last updated by` as Agent,
        c.Name as Customer, i.`Vendor Name` as Vendor, i.`Service Type` as Service,
        i.`Number of Days` as Days, i.`Confirmation #` as Confirmation, i.`Ok to Pay` as Pay,
        i.`Amount Paid` as Paid
    FROM customers c, itineraries i".$tablas."
    WHERE ".$criterios."(c.`Visit Status` = 'success' OR c.`Visit Status` = 'customer' 
        OR c.`Visit Status` = 'interested' OR c.`Visit Status` = 'prospect') AND 
        c.`Customer Id` = i.`Customer Id` AND i.`From Date` >= '".$_GET["from"]."' 
        AND i.`From Date` <= '".$_GET["to"]."' AND i.`Reservation Confirmed` = 1
    ORDER BY i.`From Date`, c.Name";
    $result=$db->query($sql);

    //echo "sql:".$sql."<br>";
    require_once('class/tcpdf4/config/lang/eng.php');
    require_once('class/tcpdf4/tcpdf.php');

    // Extend the TCPDF class to create custom Header and Footer
    class MYPDF extends TCPDF {
    }
    // create new PDF document
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true); 

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor($usuario->nombre);
    $pdf->SetTitle(COMPANY_NAME." Payment Report");
    $pdf->SetSubject("Pending Visits by ".COMPANY_NAME);
    $pdf->SetKeywords("magic, switzerland, europe, reservation, online");	
    $pdf->setPrintFooter(false);

    // set default header data
    $pdf->SetHeaderData('Enjoy-Magic2.jpg', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, '');

    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(0);

    //set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, 5);

    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 

    //set some language-dependent strings
    $pdf->setLanguageArray($l); 

    //initialize document
    $pdf->AliasNbPages();
    // add a page
    $pdf->AddPage();
    $pdf->SetFillColor(240,240,240);
    // Print Page Title
    $pdf->Ln();
    $pdf->SetFont("vera", "B", 18);
    $pdf->Cell(0,12,"Arrivals by day",0,1,'C');

    // Print Subtitles
    $pdf->SetFont("vera", "", 13);
    $pdf->Cell(0,12,"From ".$_GET["from"]." to ".$_GET["to"],0,1,'C');

    // Print Cols titles
    $pdf->SetFont("vera", "", 8);
    $pdf->Cell(30,5,"",0,0,'C');
    $pdf->Cell(30,5,"Client Name",0,0,'C');
    $pdf->Cell(60,5,"Vendor Name - Service Type",0,0,'C');
    $pdf->Cell(15,5,"Days",0,0,'C');
    $pdf->Cell(15,5,"Confirmation",0,0,'C');
    $pdf->Cell(15,5,"Pay",0,0,'C');
    $pdf->Cell(15,5,"Amount Paid",0,1,'C');
    // ---------------------------------------------------------
    //$pdf->Ln();
    $arrive = '';
    while ($visit = $db->fetchNextObject($result)) { 
        if ($arrive != $visit->FromDate) {
            if(isset($pay)) $pdf->Cell(190,7,'','T',1,'L');
            //$pdf->Ln();
            $arrive = $visit->FromDate;
            $pdf->SetFont("vera", "", 14);
            $pdf->Cell(190,7,'Arrivals '.$arrive,'T',1,'L');
        }
        // print detail
        $pay = ($visit->Pay==1) ? 'Yes' : 'No';
        $pdf->SetFont("vera", "", 7);
        $pdf->Cell(20,5,$visit->Agent,0,0,'L');
        $pdf->Cell(40,5,char_decode($visit->Customer),0,0,'R');
        $pdf->Cell(60,5,char_decode($visit->Vendor.' - '.$visit->Service),0,0,'L');
        $pdf->SetFont("vera", "", 8);
        $pdf->Cell(15,5,$visit->Days,0,0,'C');
        $pdf->SetFont("vera", "", 7);
        $confirma = char_decode($visit->Confirmation);
        if (strlen($visit->Confirmation) > 12)
            $confirma = substr($visit->Confirmation,0,12).'...';
        $pdf->Cell(15,5,  $confirma,0,0,'L');
        $pdf->SetFont("vera", "", 8);
        $pdf->Cell(15,5,$pay,0,0,'C');
        $pdf->Cell(15,5,money_format('%.2n',$visit->Paid),0,1,'R');
    } // fin del while
    $pdf->Cell(190,7,'','T',1,'L');
    //Close and output PDF document
    $pdf->Output("visits.pdf", "I");
    //============================================================+
    // END OF FILE                                                 
    //============================================================+
}
?>