<div class="boxed">
    <?php
    header('Content-Type: text/xml; charset=ISO-8859-1');
    include_once('./include/functions.php');
    include_once ("./class/tmsFinance.php");
    // global variables
    global $hostname, $database, $username, $password;
    $services = array();
    // Read customer id
    $id = is_numeric($_GET['customer']) ? $_GET['customer']: 0;

    // Function traduce
    // parameters service string
    // return string
    function traduce($service) {
        switch ($service) {
            case 'Transfer':
                $service = 'Traslado';
                break;
            case 'Airline':
                $service = 'Aerol&iacute;nea';
                break;
            case 'Consolidator':
                $service = 'Consolidador';
                break;
            case 'Car Rental':
                $service = 'Rent-a-car';
                break;
            case 'School':
                $service = 'Escuela';
                break;
            case 'Guide':
                $service = 'Gu&iacute;a';
                break;
            case 'Rail':
                $service = 'Tren';
                break;
            case 'Tourism Office':
                $service = 'Oficina de Turismo';
                break;
            case 'Vacation Home':
                $service = 'Casa Vacacional';
                break;
            case 'Various':
                $service = 'Varios';
        }
        return $service;
    }
    // read customer info
    $sql="SELECT `Customer Number` Customer_Number, Name, `Language`, `Referred by` Website FROM customers WHERE `Customer Id` = ".$id;
    $customer = $db->queryUniqueObject($sql);
    // connect to tmsFinance
    $finance = new tmsFinance($id);
    // load language definitions
    if ( $customer->Language == 'Spanish' ) {
        include('./languages/es/rep1500.php');
    } else {
        include('./languages/en/rep1500.php');
    }
    // read itinerary info and create summary
    $sqlServices="SELECT `Vendor Name` Vendor, `Service Type` Service, `Internal Comments` Internal_Comments, `Type` FROM itineraries WHERE `Customer Id` = ".$id." AND `Service Type` <> 'Booking Engine' GROUP BY `Vendor Name` ORDER BY `Service Type`";
    $sqlBE = "SELECT `Internal Comments` `service` FROM itineraries WHERE `Customer Id` = ".$id." AND `Service Type` = 'Booking Engine' GROUP BY `Internal Comments`";
    $resultBE = $db->query($sqlBE);
    while($itinerary = $db->fetchNextObject($resultBE)) {
        $message .= HOTEL.$itinerary->service."<br>\n";
        $services['Hotel'] ++;
    }
    $result = $db->query($sqlServices);
    while($itinerary = $db->fetchNextObject($result)) {
        $services[$itinerary->Service] ++;
        if(($itinerary->Vendor == 'Rail Source International' || $itinerary->Vendor == 'Railtour Suisse') && $rail == 'off') {
            $message .= RAIL."<br>\n";
            $rail = 'on';
        } elseif ($itinerary->Vendor == 'Magic Switzerland' || $itinerary->Vendor == 'MOB' ||
                $itinerary->Vendor == 'Rhaetische Bahn' || $itinerary->Vendor == ' Rhaetische Bahn AG') {
            $message .= "* ".$itinerary->Type."<br>\n";
        } else {
            $service = $itinerary->Service;
            if ( $language == 'Spanish' ) {
                $service = traduce($itinerary->Service);
            }
            $message .= "* ".$service.": ".stripslashes($itinerary->Vendor)."<br>\n";
            unset($service);
        }
    }
    $country = $db->queryUniqueValue("SELECT Description FROM `list box text` WHERE `List Box Text` LIKE '%".$customer->Website."%' AND `List Box Name` = 'Referred by'");
    if (count($services)>1) {
        // More than one service, it is a vacation package
        $product_name = $country . ' Vacation Package';
    } else {
        // Just one service
        $service = array_keys($services);
        $product_name = $country . ' ' . $service[0];
        $product_name = ($services[$service[0]] > 1) ? $product_name.'s': $product_name;
    }
    ?>
    <form method="POST" action="customers.php" name="customers">
        <h3 style="text-align:center;">E-Commerce Product Information</h3>
        <table align="center" style="width:99%"><tr>
        <!-- valign bottom to stay aligned when there is an error message. -->
            <td valign="bottom">
                <label for="mg_name" class="">Product Name</label><br>
                <textarea style="width: 90%; height: auto;" class="" cols="40" rows="1" id="mg_name" name="mg_name"><?php echo $product_name?></textarea>
            </td><td valign="bottom">
                <label for="mg_short_description" class="">Summary</label><br>
                <textarea style="width: 90%; height: auto;" class="" cols="40" rows="1" id="mg_short_description" name="mg_short_description">Custom Itinerary for <?php echo $customer->Name?></textarea>
            </td></tr>
            <tr><td valign="bottom">
                <label for="mg_description" class="">Description</label><br>
                <textarea style="width: 90%; height: auto;" class="" cols="40" rows="7" id="mg_description" name="mg_description"><?php echo strip_tags($message)?></textarea>
            </td><td valign="bottom">
                <label for="mg_ecommerce" class="">E-Commerce Select</label><br>
                ATS <input type="radio" class="" value="ATS" name="mg_ecommerce" checked="checked"> &nbsp;&nbsp;
                <?php
                if ($nombre_usuario == 'Juan Carlosa' || $nombre_usuario == 'Pepe Strub') {?>
                MTS <input type="radio" class="" value="MTS" name="mg_ecommerce">
                <?php } ?>
                <br><br><br><br><br>
                <input type="submit" class="submit" value="Enter" name="submit">
                <input type="hidden" value="0" id="mg_price" name="mg_price">
                <input type="hidden" value="<?php echo $username?>" id="Last updated by" name="Last updated by">
                <input type="hidden" value="<?php echo $id?>" id="Customer Id" name="Customer Id">
            </td>
        <tr></table>
    </form>
</div>